% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algaebase_api_functions.R
\name{match_algaebase_species}
\alias{match_algaebase_species}
\title{Search AlgaeBase for information about a species of algae}
\usage{
match_algaebase_species(
  genus,
  species,
  subscription_key = Sys.getenv("ALGAEBASE_KEY"),
  higher = TRUE,
  unparsed = FALSE,
  newest_only = TRUE,
  exact_matches_only = TRUE,
  apikey = deprecated()
)
}
\arguments{
\item{genus}{A character string specifying the genus name.}

\item{species}{A character string specifying the species or specific epithet.}

\item{subscription_key}{A character string containing the API key for accessing the AlgaeBase API. By default, the key
is read from the environment variable \code{ALGAEBASE_KEY}.

You can provide the key in three ways:
\itemize{
\item \strong{Directly as a parameter}:
\code{match_algaebase_species("Skeletonema", "marinoi", subscription_key = "your_key_here")}.
\item \strong{Temporarily for the session}:
\code{Sys.setenv(ALGAEBASE_KEY = "your_key_here")}.
After this, you do not need to pass \code{subscription_key} to the function.
\item \strong{Permanently across sessions} by adding it to your \code{~/.Renviron} file.
Use \code{usethis::edit_r_environ()} to open the file, then add:
\code{ALGAEBASE_KEY=your_key_here}.
After this, you do not need to pass \code{subscription_key} to the function.
}}

\item{higher}{A logical value indicating whether to include higher taxonomy details (default is \code{TRUE}).}

\item{unparsed}{A logical value indicating whether to print the full JSON response from the API (default is \code{FALSE}).}

\item{newest_only}{A logical value indicating whether to return only the most recent entries (default is \code{TRUE}).}

\item{exact_matches_only}{A logical value indicating whether to return only exact matches (default is \code{TRUE}).}

\item{apikey}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \code{subscription_key} instead.}
}
\value{
A \code{tibble} with details about the species, including:
\itemize{
\item \code{taxonomic_status} — The current status of the taxon (e.g., accepted, synonym, unverified).
\item \code{taxon_rank} — The rank of the taxon (e.g., species, genus).
\item \code{accepted_name} — The currently accepted scientific name, if applicable.
\item \code{authorship} — Author information for the scientific name (if available).
\item \code{mod_date} — Date when the taxonomic record was last modified.
\item \code{...} — Other relevant information returned by the data source.
}
}
\description{
This function searches the AlgaeBase API for species based on genus and species names.
It allows for flexible search parameters such as filtering by exact matches, returning
the most recent results, and including higher taxonomy details.
}
\details{
A valid API key is requested from the AlgaeBase team.

This function queries the AlgaeBase API for species based on the genus and species names,
and filters the results based on various parameters. The function handles different taxonomic ranks
and formats the output for easy use. It can merge higher taxonomy data if requested.
}
\examples{
\dontrun{
# Search for a species with exact matches only, return the most recent results
result <- match_algaebase_species(
  genus = "Skeletonema", species = "marinoi", subscription_key = "your_api_key"
)

# Print result
print(result)
}

}
\seealso{
\url{https://www.algaebase.org/} for AlgaeBase website.
}
