% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movements.R
\name{movements}
\alias{movements}
\title{Calculate movements}
\usage{
movements(
  data = NULL,
  space.use = TRUE,
  from.previous = TRUE,
  cumulative = TRUE,
  downstream.node = NULL,
  coords,
  lon.name = "lon",
  lat.name = "lat",
  id.name = "id",
  date.time.name = NULL
)
}
\arguments{
\item{data}{(list) Output from \code{\link{prep.data}}.}

\item{space.use}{(logical) If \code{TRUE} (default), total space use (range) will be calculated up to and including each point}

\item{from.previous}{(logical) If \code{TRUE} (default), the distance from the previous point will be calculated.}

\item{cumulative}{(logical) If \code{TRUE} (default), the cumulative distance moved up to and including each point will be calculated.}

\item{downstream.node}{(integer) The ID (number) of the node representing the furthest point downstream in your network (the root). If included, the distance from that point and the direction of movement (upstream or downstream) will be calculated per point.}

\item{coords}{(data.frame) Data frame containing coordinates for animal locations. At a minimum, it must include a column of animal IDs and columns of latitude and longitude (in decimal degrees projected to the same system as the rest of the data). It can optionally include a date.time column (highly recommended) containing the date and time of each point (in POSIX format). If the date.time column is present, the data will be sorted by that. Otherwise, ensure the data are sorted from oldest to newest. Other columns of metadata can be included and will be returned.}

\item{lon.name}{(character) For the \code{coords} object, the name of the column of longitudes (in quotes). Default = "lon"}

\item{lat.name}{(character) For the \code{coords} object, the name of the column of latitudes (in quotes). Default = "lat"}

\item{id.name}{(character) For the \code{coords} object, the name of the column of animal identities (in quotes). Default = "id"}

\item{date.time.name}{(character: optional) For the \code{coords} object, the name of the column of dates and times (in a POSIX format). If included, the data will be sorted from oldest to newest (otherwise sort before running), and the time difference between consecutive points will be returned. Default = \code{NULL}}
}
\value{
Data frame including all original columns, plus a columns of summary data. Column order may have changed. All measurements are in linear meters.

Column \code{space.use} = result of \code{space.use} = \code{TRUE}

Column \code{dist.from.prev} = result of \code{from.previous} = \code{TRUE}

Column \code{cumulative.dist} = result of \code{cumulative} = \code{TRUE}

Column \code{dist.from.downstream} = result of \code{downstream.node}

Column \code{direction} = result of \code{downstream.node} (direction)

Column \code{time.diff} = returned if a date.time column is included. Shows the elapsed time (in hours) between consecutive points
}
\description{
Calculate movements in a stream network for multiple individuals
}
\details{
It takes a data frame of coordinates and calculates the specified summary statistics for each individual. All results are in meters. Input data should be sorted from oldest point to newest, unless a date.time column is included, in which case the sorting will be done internally.

\code{space.use} If \code{TRUE}, for each point, it will calculate the total space use up to and including the given point. This includes all branches of the network covered by the points, but no portion is measured more than once. It is simply the total area of the stream (expressed as linear meters) visited by the animal. Note that there may occasionally be a very slight difference between this metric and the other metrics when they describe the same space. This is caused by a slight misalignment between a node and the end of a segment, but usually will be trivial.

\code{from.previous} If \code{TRUE}, for each point, it calculates the distance between that point and the previous point (following the stream network). This calculation is required for the \code{cummualtive} calculations and outputs will be returned anytime \code{cummualtive == T}, even if \code{from.previous == F}.

\code{cumulative} If \code{TRUE}, for each point, it calculates the total distance moved up to and including that point. This differs from \code{space.use} because stretches of river get included each time they are visited, so the cumulative distance increases anytime the animal moves.

\code{downstream.node} If this is included, for each point, it calculates the current distance from the point furthest downstream. This can be a useful way to visualize movements over time by referencing a fixed point (the furthest downstream). It also returns a column showing the direction of movement. Keep in mind that on branched rivers, these results may be somewhat misleading. If, for example, a stream forks 10 m upstream, and an animal moves from 5 m up the right fork then backtracks on goes 6 m up the left fork, the distances from the furthest downstream point will be 15 and 16 (respectively) even though the animal moved 5 m downstream the left fork before moving 6 m up the other. Likewise, the direction would be scored as "upstream" even though it first moved downstream. The direction is based simply on whether the shortest distance to the furthest downstream point increased or decreased.

\strong{Note}: This function does not incorporate the amount of time between points. Bear that in mind when interpreting data collected over uneven time intervals.

\strong{Example}: If an individual starts 100 meters upstream from the furthest downstream point in your network and moves 10 m upstream from day 1 to 2, another 5 m upstream from day 2 to 3, then 4 m downstream from day 3 to 4, then doesn't move between days 4 and 5, it will return the following:

\tabular{ccccl}{
\strong{space.use} \tab \strong{dist.from.prev} \tab \strong{cumulative.dist} \tab \strong{dist.from.downstream} \tab \strong{direction} \cr
NA \tab NA \tab NA \tab 100 \tab NA        \cr
10 \tab 10 \tab 10 \tab 110 \tab upstream  \cr
15 \tab  5 \tab 15 \tab 115 \tab upstream  \cr
15 \tab  4 \tab 19 \tab 111 \tab downstream\cr
15 \tab  0 \tab 19 \tab 111 \tab no.change
}

The first row is NA in most cases because there are no previous points to make comparisons. The \code{dist.from.prev} column is simply the distances described in the example. The \code{space.use} column shows increasing total space use over time. Notice that it does not change on days 4 and 5 because the animal visits areas where it had already been recorded. In contrast, the \code{cumulative.dist} increased on day 4 because it is simply the sum of all distances. Most values remained the same on the last day because there was no movement (as reflected by the \code{dist.from.prev} and \code{direction} columns).
}
\examples{

data(stream.line)
data(nodes)
data(animal.points)

network.20 <- prep.data(
  l = stream.line,
  freq = 20,
  nodes = nodes,
  lon.name = "lon",
  lat.name = "lat",
  node.name = "id"
)

move.results <- movements(data=network.20,
  space.use=TRUE,
  from.previous=TRUE,
  cumulative=TRUE,
  downstream.node=1,
  coords=animal.points,
  lon.name="lon.raw",
  lat.name="lat.raw",
  id.name="id",
  date.time.name="date.time")

}
