% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SBasedFun.R
\name{S.based.functions}
\alias{S.based.functions}
\title{Compute S-based test function for testing the null hypothesis of first-order separability}
\usage{
S.based.functions(
  X,
  s.region,
  t.region,
  owin = NULL,
  at = c("pixels", "points"),
  n.grid = c(25L, 25L, 20L),
  epsilon = NULL,
  delta = NULL,
  output = "all"
)
}
\arguments{
\item{X}{Numeric matrix/data.frame with three columns giving \eqn{(x,y,t)}.}

\item{s.region}{Numeric matrix with two columns giving polygon vertices of the spatial window.}

\item{t.region}{Numeric vector of length 2 giving the temporal window \code{c(tmin, tmax)}.}

\item{owin}{Optional spatial window of class \code{"owin"} (from \pkg{spatstat.geom}).
Used only when \code{at="pixels"} to set values outside the window to \code{NA}.}

\item{at}{Character string: \code{"pixels"} or \code{"points"}.}

\item{n.grid}{Integer vector of length 3 giving the grid resolution in \eqn{x}, \eqn{y}, and \eqn{t}
(used when \code{at="pixels"}; still checked for length/positivity in both modes).}

\item{epsilon}{Optional numeric scalar (>0). Spatial bandwidth. If \code{NULL}, estimated internally.}

\item{delta}{Optional numeric scalar (>0). Temporal bandwidth. If \code{NULL}, estimated internally.}

\item{output}{Character string selecting which component to return. Use \code{"all"} (default) to return
all available components; otherwise return only the selected component along with bandwidths and coordinates.}
}
\value{
If \code{output="all"}, returns the full list produced by the chosen computation routine, augmented with
\code{epsilon} and \code{delta}.

If \code{output} is a single component name, returns a list with:
\describe{
\item{S}{The requested component.}
\item{epsilon}{Spatial bandwidth used.}
\item{delta}{Temporal bandwidth used.}
\item{x,y,t}{Coordinates returned by the underlying routine (may be \code{NULL}).}
}
}
\description{
Computes kernel-based estimates of the spatio-temporal intensity and related
separability diagnostics, either on a regular spatio-temporal grid (\code{"pixels"})
or at the observed event locations (\code{"points"}).
}
\details{
The function is a wrapper that (i) validates inputs, (ii) computes bandwidths and
Gaussian edge-correction masses via \code{\link{calc.bandwidths.and.edgecorr}}, and
(iii) delegates the actual estimation to \code{\link{estimate.intensity.pixel}} or
\code{\link{estimate.intensity.point}}.

When \code{at="points"}, spatial/temporal profiles such as \code{S.space} and \code{S.time} are typically
not defined and are returned as \code{NULL} by the pointwise routine.
}
\examples{

X <- cbind(stats::runif(50), stats::runif(50), stats::runif(50))
s.region <- matrix(c(0,0, 1,0, 1,1, 0,1), ncol = 2, byrow = TRUE)
t.region <- c(0, 1)
res_all <- S.based.functions(X, s.region, t.region, at = "points")
res_Sfun <- S.based.functions(X, s.region, t.region, at = "points", output = "S.fun")

}
