% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimEUCartelLaw.r
\name{aggResults}
\alias{aggResults}
\title{Aggregate results of the legal exemption game simulation}
\usage{
aggResults(res)
}
\arguments{
\item{res}{dataframe containing results of simulation using \code{LEgame}.}
}
\value{
A matrix containing the aggregated results.
}
\description{
\code{aggResults} aggregates the results of \code{LEgame}.
}
\details{
\code{aggResults} aggregates the results of \code{LEgame} to a matrix
containing information about the fractions for the potential equilibria as
well as the means and standard deviations of the error probabilities, the
compliance level, and the expected illegal gains.
}
\examples{
Par <- list(Phi=c(0.1,0.5), Rho=c(0.5,0.9), Ksi=c(0.05,0.3), Chi=c(0.1,0.4),
            M=c(0.2,1.2), G=c(0.05,0.2), A=c(0.1,0.3))
res <- LEgame(params=Par, m=100000)
print(aggResults(res))

}
