# SpuriousMemory
## Test for the null hypothesis of fractional integration against spurious long memory

## Overview

Detecting spurious long memory in time series using the method of Qu (2011).
Distinguishes between true stationary long memory and spurious long memory
caused by level shifts or smooth trends.

## Example

```r
library(SpuriousMemory)

# Data
data(RV5min)

result <- Longmemorytest(RV5min, demean = TRUE, alpha = 0.05)
```

## References

- Qu, Z. (2011). "Test Against Spurious Long Memory". Journal of Business & Economic Statistics, 29(3), 423-438.