% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeostTextureLibrarySharedRoxy.R
\name{Trik2.numeric}
\alias{Trik2.numeric}
\title{Improved TRI (with differences of order 2), reducing/removing slope dependence (for testing purposes)}
\usage{
\method{Trik2}{numeric}(x)
}
\arguments{
\item{x}{A vector of numeric values from a focal window in a DEM from which to compute the index}
}
\value{
isotropic roughness (in the same units of input)
}
\description{
It is essentially a radial roughness index.This has been created for explaining the derivation of RRI, and it is not
supposed to be used for doing real analysis.
TRIk2 modifies TRI (topographic ruggedness index) using increments of order 2, symmetrical to central pixel,
so as to remove the effect of local slope.
This version does not correct for diagonal distance and therefore is mainly for testing/simulation purposes,
so in practice the Radial Roughness Index calculated by the RRI function should be used instead.
It uses a 5x5 kernel, consequently 12 directional differences of order k (2)
are used in the estimation.
One could also use a 3x3 kernel using only the 4 differences centered on the central pixel
but the metric would be very noisy.
The input is the DEM (no need to detrend).
}
\examples{
library(terra)
dem=rast(paste(system.file("extdata", package = "SurfRough"), "/trento1.tif",sep=""))
w <- matrix(1, nrow=5, ncol=5)
roughTrik5x5=focal(dem, w=w, fun=Trik2)
plot(roughTrik5x5)

}
\references{
\enumerate{
\item Riley, S. J., S. D. DeGloria, and R. Elliott. 1999.
A terrain ruggedness index that quantifies topographic heterogeneity.
Intermountain Journal of Science 5:23.
\item Wilson, M.F.J., O'Connell, B., Brown, C., Guinan, J.C. & Grehan, A.J. 2007.
Multiscale terrain analysis of multibeam bathymetry data for habitat mapping on the continental slope".
Marine Geodesy, vol. 30, no. 1-2, pp. 3-35.
\item Trevisani S., Teza G., Guth P.L., 2023. Hacking the topographic ruggedness index. Geomorphology
\doi{doi:10.1016/j.geomorph.2023.108838}.
}
}
