% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighting.R
\name{weighted_total}
\alias{weighted_total}
\title{Calculate weighted total}
\usage{
weighted_total(data, target_col, weight_col)
}
\arguments{
\item{data}{A data.frame containing survey data}

\item{target_col}{Character string specifying column name for target variable}

\item{weight_col}{Character string specifying column name containing weights}
}
\value{
Numeric weighted total
}
\description{
This function calculates the weighted total of a numeric variable.
Useful for estimating population totals from survey data.
}
\examples{
data <- data.frame(income = c(50000, 75000, 100000), weight = c(1000, 800, 1200))
total_income <- weighted_total(data, "income", "weight")
}
