# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Precompute All Topological Sorts
#'
#' This function precomputes all topological sorts for a given preference matrix.
#' Topological sorts are consistent orderings of items that respect the given
#' pairwise preference constraints.
#'
#' @param prefs A matrix representing the preference relations. This matrix
#'   must have two columns, the first of which represents the preferred item
#'   and the second of which represents the disfavored item.
#' @param n_items An integer specifying the number of items to sort.
#' @param save_frac Number between 0 and 1 specifying which fraction of sorts to save.
#'
#' @details
#' The function generates all possible topological sorts for the provided preference matrix
#' and saves approximately \code{save_frac} of the sorts in a matrix which is returned.
#'
#' @return A list with two elements:
#' \describe{
#'   \item{sort_count}{An integer giving the total number of topological sorts.}
#'   \item{sort_matrix}{A matrix where each column represents one topological sort.
#'     The number of columns is approximately \code{save_frac} times \code{sort_count}.
#'     If \code{save_frac = 0}, this is an empty matrix with dimensions \code{c(0, 0)}.}
#' }
#'
#' @export
#' @examples
#' # Extract preferences from user 1 in the included example data.
#' prefs <- pairwise_preferences[
#'  pairwise_preferences$user == 1, c("top_item", "bottom_item"), drop = FALSE]
#'
#' # Generate all topological sorts, but don't save them:
#' sorts <- precompute_topological_sorts(
#'   prefs = as.matrix(prefs),
#'   n_items = 5,
#'   save_frac = 0
#' )
#' # Number of sorts
#' sorts$sort_count
#' # Empty matrix
#' sorts$sort_matrix
#'
#' # Generate all topological sorts and save them:
#' sorts <- precompute_topological_sorts(
#'   prefs = as.matrix(prefs),
#'   n_items = 5,
#'   save_frac = 1
#' )
#' # Number of sorts
#' sorts$sort_count
#' # Matrix with all of them
#' sorts$sort_matrix
#'
precompute_topological_sorts <- function(prefs, n_items, save_frac) {
    .Call(`_BayesMallowsSMC2_precompute_topological_sorts`, prefs, n_items, save_frac)
}

run_smc <- function(input_timeseries, input_prior, input_options, input_sort_matrices, input_sort_counts) {
    .Call(`_BayesMallowsSMC2_run_smc`, input_timeseries, input_prior, input_options, input_sort_matrices, input_sort_counts)
}

