% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocessing.R
\name{handle_missing_data}
\alias{handle_missing_data}
\title{handle_missing_data}
\usage{
handle_missing_data(data, col.index)
}
\arguments{
\item{data}{data.frame object.}

\item{col.index}{numeric vector specifying which columns to inspect}
}
\value{
data.frame object with the data and the missingness indicators described above.
}
\description{
use col.index to determine which columns we want to "scan" for missing data. Note that in earlier points in the code, we rearrange the columns and prepare the data frame such that cols 1-4 are bookkeeping (unit id, time id, treated variable, unlagged outcome variable) and all remaining columns are used in the calculations after going through parse_and_prep function, so col.index should usually be 5:ncol(data). In practice, this function just looks over the data in the specified columns in the "data" data frame for missing data. Then it creates columns with indicator variables about the missingness of those variables: 1 for missing data, 0 for present
}
\details{
Tags missing data
}
\keyword{internal}
