% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{validate_input}
\alias{validate_input}
\title{Validate Input Data Structure}
\usage{
validate_input(
  y,
  X = NULL,
  time_index = NULL,
  na_action = c("fail", "omit", "interpolate"),
  min_obs = 10,
  verbose = FALSE
)
}
\arguments{
\item{y}{Numeric vector representing the target signal. Must be a numeric
vector with no infinite values. Missing values (NA) are handled according
to the \code{na_action} parameter.}

\item{X}{Optional matrix or data frame of candidate predictors. If provided,
must have the same number of rows as length(y).}

\item{time_index}{Optional vector of time indices. If NULL, sequential
integers will be used.}

\item{na_action}{Character string specifying how to handle missing values.
Options are "fail" (stop with error), "omit" (remove observations with NA),
or "interpolate" (linear interpolation).}

\item{min_obs}{Minimum number of observations required. Default is 10.}

\item{verbose}{Logical indicating whether to print diagnostic messages.}
}
\value{
A list with validated and potentially transformed data:
\describe{
\item{y}{Validated numeric vector of target signal}
\item{X}{Validated matrix of predictors (or NULL)}
\item{time_index}{Vector of time indices}
\item{n_obs}{Number of observations}
\item{n_vars}{Number of predictor variables (or 0)}
\item{var_names}{Names of predictor variables (or NULL)}
\item{na_indices}{Indices of removed observations (if any)}
}
}
\description{
Validates that input data meets the requirements for SignalY analysis.
Performs comprehensive checks on data types, dimensions, missing values,
and numeric properties.
}
\details{
This function implements defensive programming principles to ensure data
integrity before computationally intensive analyses. The validation process
includes:

\enumerate{
\item Type checking: Ensures y is numeric and X (if provided) is numeric
matrix/data.frame
\item Dimension checking: Verifies compatible dimensions between y and X
\item Missing value handling: Processes NA values according to specified
action
\item Finiteness checking: Removes or flags infinite values
\item Minimum sample size: Ensures sufficient observations for analysis
}
}
\keyword{internal}
