% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/tests.R
\name{linkSignificance}
\alias{linkSignificance}
\alias{link_significance}
\title{Estimate statistical deviations from ghype model}
\usage{
linkSignificance(
  graph,
  model,
  under = FALSE,
  log.p = FALSE,
  binomial.approximation = FALSE,
  give_pvals = FALSE
)

link_significance(
  graph,
  model,
  under = FALSE,
  log.p = FALSE,
  binomial.approximation = FALSE,
  give_pvals = FALSE
)
}
\arguments{
\item{graph}{an adjacency matrix or a igraph object.}

\item{model}{a ghype model}

\item{under}{boolean, estimate under-represented deviations? Default FALSE.}

\item{log.p}{boolean, return log values of probabilities}

\item{binomial.approximation}{boolean, force binomial? default FALSE}

\item{give_pvals}{boolean, return p-values for both under and over significance?}
}
\value{
matrix of probabilities with same size as adjacency matrix.
}
\description{
linkSignificance allows to estimate the statistical deviations of an observed
graph from a ghype model.
}
\examples{
data("adj_karate")
fullmodel <- ghype(graph = adj_karate, directed = FALSE, selfloops = FALSE)
link_significance(graph = adj_karate, model = fullmodel, under=FALSE)

}
