% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_grid.R
\name{hexify_grid}
\alias{hexify_grid}
\title{Create a hexagonal grid specification}
\usage{
hexify_grid(
  area,
  topology = "HEXAGON",
  metric = TRUE,
  resround = "nearest",
  aperture = 3,
  projection = "ISEA"
)
}
\arguments{
\item{area}{Target cell area in km^2 (if metric=TRUE) or area code}

\item{topology}{Grid topology (only "HEXAGON" supported)}

\item{metric}{Whether area is in metric units (km^2)}

\item{resround}{How to round resolution ("nearest", "up", "down")}

\item{aperture}{Aperture sequence (3, 4, or 7)}

\item{projection}{Projection type (only 'ISEA' supported currently)}
}
\value{
A hexify_grid object containing:
\item{area}{Target cell area}
\item{resolution}{Calculated resolution level}
\item{aperture}{Grid aperture (3, 4, or 7)}
\item{topology}{Grid topology ("HEXAGON")}
\item{projection}{Map projection ("ISEA")}
\item{index_type}{Index encoding type ("z3", "z7", or "zorder")}
}
\description{
Creates a discrete global grid system (DGGS) object with hexagonal cells
at a specified resolution. This is the main constructor for hexify grids.
}
\examples{
# Create a grid with ~1000 km^2 cells
grid <- hexify_grid(area = 1000, aperture = 3)
print(grid)

# Create a finer resolution grid (~100 km^2 cells)
fine_grid <- hexify_grid(area = 100, aperture = 3, resround = "up")
}
\seealso{
\code{\link{hexify}} for the main user function,
\code{\link{hexify_grid_to_cell}} for coordinate conversion

Other hexify main: 
\code{\link{hexify}()}
}
\concept{hexify main}
