% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_pwdist.R
\name{pwdist}
\alias{pwdist}
\title{Procrustes-Wasserstein Distance}
\usage{
pwdist(X, Y, wx = NULL, wy = NULL, ...)
}
\arguments{
\item{X}{an \eqn{(M\times P)} matrix of row observations.}

\item{Y}{an \eqn{(N\times P)} matrix of row observations.}

\item{wx}{a length-\eqn{M} marginal density that sums to \eqn{1}. If \code{NULL} (default), uniform weight is set.}

\item{wy}{a length-\eqn{N} marginal density that sums to \eqn{1}. If \code{NULL} (default), uniform weight is set.}

\item{...}{extra parameters including \describe{
\item{maxiter}{maximum number of iterations (default: 496).}
\item{abstol}{stopping criterion for iterations (default: 1e-10).}
}}
}
\value{
a named list containing\describe{
\item{distance}{the computed PW distance value.}
\item{plan}{an \eqn{(M\times N)} nonnegative matrix for the optimal transport plan.}
\item{alignment}{an optimal alignment matrix of size  \eqn{(P\times P)} in \eqn{\mathcal{O}(P)}.}
}
}
\description{
Given two empirical measures
\deqn{\mu = \sum_{m=1}^M \mu_m \delta_{X_m}\quad\textrm{and}\quad \nu = \sum_{n=1}^N \nu_n \delta_{Y_n}} in 
\eqn{\mathbb{R}^P}, the Procrustes-Wasserstein (PW) distance is defined as follows:
\deqn{
  PW_2^2(\mu, \nu) = \min_{Q\in \mathcal{O}(P)} W_2^2(\mu, Q_\# \nu),
}
where \eqn{\mathcal{O}(P)} is the orthogonal group and \eqn{Q_\#\nu} is the pushforward via \eqn{Q}.
}
\examples{
\dontrun{
#-------------------------------------------------------------------
#                           Description
#
# * class 1 : samples from N((0,0),  diag(c(4,1/4)))
# * class 2 : samples from N((10,0), diag(c(1/4,4)))
# * class 3 : samples from N((10,0), diag(c(1/4,4))) randomly rotated
#
#  We draw 10 empirical measures from each and compare 
#  the regular Wasserstein and PW distance.
#-------------------------------------------------------------------
## GENERATE DATA
set.seed(10)

#  prepare empty lists
inputs = vector("list", length=30)

#  generate
random_rot = qr.Q(qr(matrix(runif(4), ncol=2)))
for (i in 1:10){
  inputs[[i]] = matrix(rnorm(50*2), ncol=2)
}
for (j in 11:20){
  base_draw = matrix(rnorm(50*2), ncol=2)
  base_draw[,1] = base_draw[,1] + 10
  
  inputs[[j]] = base_draw
  inputs[[j+10]] = base_draw\%*\%random_rot
}

## COMPUTE
#  empty arrays
dist_RW = array(0, c(30, 30))
dist_PW = array(0, c(30, 30))

#  compute pairwise distances
for (i in 1:29){
  for (j in (i+1):30){
  dist_RW[i,j] <- dist_RW[j,i] <- wasserstein(inputs[[i]], inputs[[j]])$distance
  dist_PW[i,j] <- dist_PW[j,i] <- pwdist(inputs[[i]], inputs[[j]])$distance
  }
}

## VISUALIZE
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2), pty="s")
image(dist_RW, xaxt="n", yaxt="n", main="Regular Wasserstein distance")
image(dist_PW, xaxt="n", yaxt="n", main="PW distance")
par(opar)
}

}
\references{
\insertRef{adamo_2025_DepthLookProcrustesWasserstein}{T4transport}
}
\concept{dist}
