% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vech.R
\name{vech}
\alias{vech}
\alias{inv_vech}
\alias{dim_vech}
\title{Flatten a symmetric matrix into a vector.}
\usage{
vech(m, name = FALSE)

inv_vech(x)

dim_vech(x)
}
\arguments{
\item{m}{A symmetric matrix}

\item{name}{If TRUE vector elements are named \code{eij} where \code{i} is the row and \code{j} is the column.}

\item{x}{A flattened symmetric matrix (as a vector).}
}
\value{
\code{vech()} returns a vector. \code{inv_vech()} returns a matrix. \code{dim_vech()} returns an integer.
}
\description{
The \code{vech} operator as defined by \insertCite{@Section 3.8 @magnus2019ma}{TFORGE} flattens symmetric matrices into vectors. Columns are extracted from left to right with entries above the diagonal ignored.
The function \code{inv_vech()} is the inverse of \code{vech()}.
The dimension of the matrix can be obtained from its flattened form by \code{dim_vech()}.
}
\details{
The extraction is conveniently performed by \code{m[lower.tri(m), diag = TRUE]}.
The matrix \code{m} is not checked for symmetry.
}
\examples{
m <- inv_vech(1:6)
dim_vech(1:6)
vech(m)
}
\references{
\insertAllCited{}
}
