% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_helpers.R
\name{extract_terms}
\alias{extract_terms}
\title{Extract and format terms from solutions}
\usage{
extract_terms(solutions, var_names, use_tilde = TRUE)
}
\arguments{
\item{solutions}{Character vector. Solution expressions.}

\item{var_names}{Character vector. Variable names used in the analysis.}

\item{use_tilde}{Logical. If TRUE, negation is represented as \code{~VAR}.}
}
\value{
List with:
  \itemize{
    \item \code{all_terms} — all terms (with duplicates)
    \item \code{unique_terms} — unique terms
    \item \code{n_total} — total term count
    \item \code{n_unique} — unique term count
  }
}
\description{
Extracts individual terms from solution expressions and returns
formatted unique terms.
}
\examples{
var_names <- c("X1", "X2", "X3")
solutions <- c("X1*X2 + X3", "X1*X2 + X1*X3")
extract_terms(solutions, var_names)
}
