% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_dist.R
\name{conditional.empirical_dist}
\alias{conditional.empirical_dist}
\title{Method for obtaining the condition distribution, \code{x | P(x)}, of
\code{empirical_dist} object \code{x}.}
\usage{
\method{conditional}{empirical_dist}(x, P, ...)
}
\arguments{
\item{x}{The empirical distribution object.}

\item{P}{The predicate function to condition the data on.}

\item{...}{additional arguments to pass into \code{P}.}
}
\description{
In other words, we condition the data on the predicate function.
In order to do so, we simply remove all rows from the data that do not
satisfy the predicate P. For instance, if we have a 2-dimensional
distribution, and we want to condition on the first dimension being
greater than the second dimension, we would do the following:
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{x_cond <- conditional(x, function(d) d[1] > d[2])
}\if{html}{\out{</div>}}

This would return a new empirical distribution object with the same
dimensionality as \code{x}, but with all rows where the first dimension is
less than or equal to the second dimension removed.
}
