% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_modis_swath}
\alias{process_modis_swath}
\title{Mosaic MODIS swaths}
\usage{
process_modis_swath(
  path = NULL,
  date = NULL,
  subdataset = NULL,
  suffix = ":mod06:",
  resolution = 0.05,
  ...
)
}
\arguments{
\item{path}{character. Full paths of hdf files.}

\item{date}{character(1). Date to query.}

\item{subdataset}{character. Subdatasets to process.
\strong{Unlike other preprocessing functions, this argument should specify
the exact subdataset name.} For example, when using MOD06_L2 product,
one may specify \code{c("Cloud_Fraction", "Cloud_Optical_Thickness")},
etc. The subdataset names can be found in \code{terra::describe()} output.}

\item{suffix}{character(1). Should be formatted \verb{:\{product\}:},
e.g., \verb{:mod06:}}

\item{resolution}{numeric(1). Resolution of output raster.
Unit is degree (decimal degree in WGS84).}

\item{...}{For internal use.}
}
\value{
\itemize{
\item a \code{SpatRaster} object (crs = \code{"EPSG:4326"}): if \code{path} is a single file with
full specification of subdataset.
\item a \code{SpatRaster} object (crs = \code{"EPSG:4326"}): if \code{path} is a list of files. In this case, the returned object will have the maximal extent of multiple warped layers
}
}
\description{
This function will return a \code{SpatRaster} object with
values of selected subdatasets. Swath data include curvilinear
grids, which require warping/rectifying the original curvilinear grids
into rectilinear grids. The function internally warps each of inputs
then mosaic the warped images into one large \code{SpatRaster} object.
Users need to select a subdataset to process. The full path looks like
\code{"HDF4_EOS:EOS_SWATH:{file_path}:mod06:subdataset"}, where file_path is
the full path to the hdf file.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
mod06l2_swath <- process_modis_swath(
  path = list.files(
    "./data/mod06l2",
    full.names = TRUE,
    pattern = ".hdf"
  ),
  date = "2024-01-01",
  subdataset = "Cloud_Fraction",
  suffix = ":mod06:",
  resolution = 0.05
)
}
}
\seealso{
\itemize{
\item \code{\link[=process_modis_warp]{process_modis_warp()}}, \code{\link[stars:read_stars]{stars::read_stars()}}, \code{\link[stars:st_warp]{stars::st_warp()}}
\item \href{https://gdal.org/en/latest/drivers/raster/hdf4.html}{GDAL HDF4 driver documentation}
\item \code{\link[terra:describe]{terra::describe()}}: to list the full subdataset list with \code{sds = TRUE}
\item \code{\link[terra:sprc]{terra::sprc()}}, \code{\link[terra:rast]{terra::rast()}}
}
}
\author{
Insang Song
}
