% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aphylo_mcmc.R, R/formulas.R
\docType{data}
\name{APHYLO_DEFAULT_MCMC_CONTROL}
\alias{APHYLO_DEFAULT_MCMC_CONTROL}
\alias{aphylo_mcmc}
\alias{MCMC}
\alias{APHYLO_PARAM_DEFAULT}
\title{Model estimation using Markov Chain Monte Carlo}
\format{
An object of class \code{list} of length 6.

An object of class \code{numeric} of length 9.
}
\usage{
APHYLO_DEFAULT_MCMC_CONTROL

aphylo_mcmc(
  model,
  params,
  priors = uprior(),
  control = list(),
  check_informative = getOption("aphylo_informative", FALSE),
  reduced_pseq = getOption("aphylo_reduce_pseq", TRUE)
)

APHYLO_PARAM_DEFAULT
}
\arguments{
\item{model}{A model as specified in \link{aphylo-model}.}

\item{params}{A vector of length 7 with initial parameters. In particular
\code{psi[1]}, \code{psi[2]}, \code{mu[1]}, \code{mu[2]}, \code{eta[1]}, \code{eta[2]} and \code{Pi}.}

\item{priors}{A function to be used as prior for the model (see \link{bprior}).}

\item{control}{A list with parameters for the optimization method (see
details).}

\item{check_informative}{Logical scalar. When \code{TRUE} the algorithm
stops with an error when the annotations are uninformative (either 0s or 1s).}

\item{reduced_pseq}{Logical. When \code{TRUE} it will use a reduced peeling sequence
in which it drops unannotated leafs. If the model includes \code{eta} this is set
to \code{FALSE}.}
}
\value{
An object of class \link{aphylo_estimates}.
}
\description{
The function is a wrapper of \code{\link[fmcmc:MCMC]{fmcmc::MCMC()}}.
}
\details{
\code{APHYLO_DEFAULT_MCMC_CONTROL} lists the default values for the MCMC
estimation:
\itemize{
\item \code{nsteps}: \code{1e4L}
\item \code{burnin}: \code{5e3L}
\item \code{thin} : \code{10L}
\item \code{nchains} : \code{2L}
\item \code{multicore} : \code{FALSE}
\item \code{conv_checker} : \code{fmcmc::convergence_auto(5e3)}
}

For more information about the MCMC estimation process, see \code{\link[fmcmc:MCMC]{fmcmc::MCMC()}}.

Methods \code{\link[base:print]{base::print()}}, \code{\link[base:summary]{base::summary()}}, \link[stats:coef]{stats::coef}, \code{\link[stats:window]{stats::window()}},
\code{\link[stats:vcov]{stats::vcov()}}, \code{\link[stats:logLik]{stats::logLik()}}, \link[=predict.aphylo_estimates]{predict()},
and the various ways to query features of the trees via \link[ape:summary.phylo]{Ntip()}
are available post estimation.

The vector \code{APHYLO_PARAM_DEFAULT} lists the starting values for the parameters
in the model. The current defaults are:
\itemize{
\item \code{psi0}: 0.10
\item \code{psi1}: 0.05
\item \code{mu_d0}: 0.90
\item \code{mu_d1}: 0.50
\item \code{mu_s0}: 0.10
\item \code{mu_s1}: 0.05
\item \code{eta0}: 1.00
\item \code{eta1}: 1.00
\item \code{Pi}: 0.50
}
}
\examples{
# Using the MCMC ------------------------------------------------------------

\donttest{

set.seed(1233)
# Simulating a tree
tree <- sim_tree(200)

# Simulating functions
atree <- raphylo(
  tree = tree,
  psi  = c(.01, .03),
  mu_d = c(.05, .02),
  Pi   = .5
)

# Running the MCMC
set.seed(1231)

ans_mcmc <- aphylo_mcmc(
  atree ~ mu_d + psi + eta + Pi,
  control = list(nsteps = 2e5, burnin=1000, thin=200)
)
}
}
\seealso{
Other parameter estimation: 
\code{\link{aphylo_mle}()}
}
\concept{parameter estimation}
\keyword{datasets}
