% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ape.R
\name{as.phylo}
\alias{as.phylo}
\alias{as.phylo.matrix}
\alias{as.phylo.aphylo}
\title{Extensions to the \code{as.phylo} function}
\usage{
\method{as.phylo}{matrix}(x, edge.length = NULL, root.edge = NULL, ...)

\method{as.phylo}{aphylo}(x, ...)
}
\arguments{
\item{x}{Either an edgelist or an object of class \link{aphylo}.}

\item{edge.length}{A vector with branch lengths  (optional).}

\item{root.edge}{A numeric scalar with the length for the root node (optional).}

\item{...}{Further arguments passed to the method.}
}
\value{
An integer matrix of the same dimmension as \code{edges} with the following
aditional attribute:
\item{labels}{Named integer vector of size \code{n}. Original labels of the edgelist
where the first \code{n} are leaf nodes, \code{n+1} is the root node, and the reminder
are the internal nodes.}
}
\description{
This function takes an edgelist and recodes (relabels) the nodes following
\CRANpkg{ape}'s coding convention.
}
\examples{

# A simple example ----------------------------------------------------------
# This tree has a coding different from ape's

mytree <- matrix(c(1, 2, 1, 3, 2, 4, 2, 5), byrow = TRUE, ncol=2)
mytree

ans <- as.phylo(mytree)
ans
plot(ans)


}
