% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth.R
\name{rgr}
\alias{rgr}
\title{Relative Growth Rate (RGR)}
\usage{
rgr(ibw, fbw, duration, mean_fun = "init")
}
\arguments{
\item{ibw}{numeric; provides the initial weight in gram.}

\item{fbw}{numeric; provides the final weight in gram.}

\item{duration}{numeric; duration of the growth experiment.}

\item{mean_fun}{character; specifies how ("init", "geometric" or 
"arithmetic") to calculate the denominator. Default: "init".}
}
\value{
either a single numeric value or vector holding the calculated RGR
values. Multiply by 100 for conversion into percentage.
}
\description{
A function that calculates the Relative Growth Rate (RGR), which is the 
relative weight increase per time unit.
}
\examples{
data(weight2)
dplyr::mutate(weight2, RGR = rgr(ibw_g, fbw_g, duration = 84))

}
\references{
Lugert, V., Thaller, G., Tetens, J., Schulz, C., & Krieter, J.
(2016): A review on fish growth calculation: multiple functions in fish
production and their specific application. Reviews in Aquaculture, 8,
p.30–42.
}
\author{
Anıl Axel Tellbüscher
}
