% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_load}
\alias{am_load}
\title{Load an Automerge document from binary format}
\usage{
am_load(data)
}
\arguments{
\item{data}{A raw vector containing a serialized Automerge document}
}
\value{
An external pointer to the Automerge document with class
\code{c("am_doc", "automerge")}.
}
\description{
Deserializes an Automerge document from the standard binary format.
The binary format is compatible across all Automerge implementations
(JavaScript, Rust, etc.).
}
\examples{
# Create, save, and reload
doc1 <- am_create()
bytes <- am_save(doc1)
doc2 <- am_load(bytes)

# Save to and load from file
file <- tempfile()
writeBin(am_save(doc1), file)

doc <- am_load(readBin(file, "raw", 1e5))
unlink(file)
}
