% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community_sim.R
\name{community_sim}
\alias{community_sim}
\title{community_bam: Community \code{bamm}}
\usage{
community_sim(
  en_models,
  ngbs_vect,
  init_coords,
  nsteps,
  threshold_vec = NULL,
  stochastic_dispersal = FALSE,
  disp_prop2_suitability = TRUE,
  disper_prop = 0.5,
  rcpp = TRUE
)
}
\arguments{
\item{en_models}{A stack or directory with the ecological niche models for
each species in the community.}

\item{ngbs_vect}{A vector containing the number of neighbors for each
adjacency matrix of each species in the community
see \code{\link[bamm]{adj_mat}}.}

\item{init_coords}{A data.frame with 3 columns: sp_name, x and
y; x is the longitude and y is the latitude of initial dispersal points}

\item{nsteps}{Number of iteration steps for the simulation.}

\item{threshold_vec}{A vector of threshold values used to bnarize niche
models.}

\item{stochastic_dispersal}{Logical. If dispersal depends on a probability of
visiting neighbor cells (Moore neighborhood).}

\item{disp_prop2_suitability}{Logical. If probability of dispersal
is proportional to the suitability of reachable cells. The proportional}

\item{disper_prop}{Probability of dispersal to reachable cells.}

\item{rcpp}{Logical. Use native C++ code to run the model.
value must be declared in the parameter `disper_prop`.}
}
\value{
An object of class community_sim. The object contains simulation
results for each species in the community.
}
\description{
Estimate community dynamics using the \code{bamm} framework
}
\details{
Each element in community_sim is an object of class. For more
details about the simulation see \code{\link[bamm]{sdm_sim}}.
\code{\link[bamm]{bam}}.
}
\examples{
\donttest{
lagos_path <- system.file("extdata/conejos",
                          package = "bamm")
enm_path <- list.files(lagos_path,
                       pattern = ".tif",
                       full.names = TRUE)[seq(1,10)]
en_models <- raster::stack(enm_path)
ngbs_vect <- sample(1:2,replace = TRUE,
                    size = raster::nlayers(en_models))
init_coords <- read.csv(file.path(lagos_path,
                                  "lagos_initit.csv"))[seq(1,10),]
nsteps <- 12
sdm_comm <- bamm::community_sim(en_models = en_models,
                                ngbs_vect = ngbs_vect,
                                init_coords = init_coords,
                                nsteps = nsteps)

com_pam <- bamm::csim2pam(sdm_comm,which_steps = seq(1,nsteps))
rich_pam <- pam2richness(com_pam,which_steps = c(1,5,10))
raster::plot(rich_pam)
}
}
\references{
\insertRef{SoberonOsorio}{bamm}.
}
\author{
Luis Osorio-Olvera & Jorge Soberon
}
