% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting_triangle-methods.R
\name{as.data.frame.reporting_triangle}
\alias{as.data.frame.reporting_triangle}
\title{Convert reporting_triangle to data.frame}
\usage{
\method{as.data.frame}{reporting_triangle}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{A \link{reporting_triangle} object to convert.}

\item{row.names}{NULL or character vector giving row names for the data
frame. Missing values are not allowed.}

\item{optional}{Logical. If TRUE, setting row names and converting column
names is optional.}

\item{...}{Additional arguments to be passed to or from methods.}
}
\value{
A data.frame with columns reference_date, report_date, delay, count
}
\description{
Convert reporting_triangle to data.frame
}
\examples{
# Convert reporting triangle to data frame
df <- as.data.frame(example_reporting_triangle)
head(df)
}
\seealso{
Reporting triangle construction and validation
\code{\link{[.reporting_triangle}()},
\code{\link{[<-.reporting_triangle}()},
\code{\link{as.matrix.reporting_triangle}()},
\code{\link{as_ChainLadder_triangle}()},
\code{\link{as_reporting_triangle}()},
\code{\link{as_reporting_triangle.data.frame}()},
\code{\link{as_reporting_triangle.matrix}()},
\code{\link{as_reporting_triangle.triangle}()},
\code{\link{assert_reporting_triangle}()},
\code{\link{get_delays_from_dates}()},
\code{\link{get_delays_unit}()},
\code{\link{get_max_delay}()},
\code{\link{get_mean_delay}()},
\code{\link{get_quantile_delay}()},
\code{\link{get_reference_dates}()},
\code{\link{get_report_dates}()},
\code{\link{get_reporting_structure}()},
\code{\link{head.reporting_triangle}()},
\code{\link{is_reporting_triangle}()},
\code{\link{new_reporting_triangle}()},
\code{\link{print.reporting_triangle}()},
\code{\link{reporting_triangle-class}},
\code{\link{summary.reporting_triangle}()},
\code{\link{tail.reporting_triangle}()},
\code{\link{truncate_to_delay}()},
\code{\link{truncate_to_quantile}()},
\code{\link{validate_reporting_triangle}()}
}
\concept{reporting_triangle}
