% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{.validate_inputs_uncertainty}
\alias{.validate_inputs_uncertainty}
\title{Validate the specified number of reference times meets the minimum
requirements}
\usage{
.validate_inputs_uncertainty(
  n_ref_times,
  n_min_delay,
  n_history_delay,
  n_retrospective_nowcasts,
  n_min_retro_nowcasts = 2
)
}
\arguments{
\item{n_ref_times}{Integer indicating the number of reference times
available.}

\item{n_min_delay}{Integer indicating minimum number of
reference times needed for delay estimation.}

\item{n_history_delay}{Integer indicating the number of reference times
(observations) to be used in the estimate of the reporting delay, always
starting from the most recent reporting delay.}

\item{n_retrospective_nowcasts}{Integer indicating the number of
retrospective nowcast times to use for uncertainty estimation.}

\item{n_min_retro_nowcasts}{Integer indicating the minimum number of
reference times needed for uncertainty estimation. Default is \code{2}.}
}
\value{
NULL, invisibly
}
\description{
Validate the specified number of reference times meets the minimum
requirements
}
\keyword{internal}
