% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{preprocess_negative_values}
\alias{preprocess_negative_values}
\title{Preprocess negative values in the reporting triangle}
\usage{
preprocess_negative_values(reporting_triangle, validate = TRUE)
}
\arguments{
\item{reporting_triangle}{A \link{reporting_triangle} object.}

\item{validate}{Logical. If TRUE (default), validates the object. Set to
FALSE only when called from functions that already validated.}
}
\value{
A \link{reporting_triangle} object with negative values handled via
redistribution to earlier delays.
}
\description{
Takes in a reporting triangle and returns it with negative values of
reporting handled by redistributing them to earlier delays (from longer
delay to shorter). This is useful when dealing with reporting corrections
that can result in negative incremental counts.

When negative values are detected, they are set to zero and the negative
amount is subtracted from the count at the next earlier delay (moving from
right to left in each row). This process continues until either the
negative value is fully absorbed or the first delay is reached.

This code was adapted from code written (under an MIT license)
by the Karlsruhe Institute of Technology RESPINOW
German Hospitalization Nowcasting Hub.
Modified from \url{https://github.com/KITmetricslab/RESPINOW-Hub/blob/main/code/baseline/functions.R} #nolint
}
\details{
Use this function when:
\itemize{
\item Your data contains reporting corrections that result in negative counts
\item You want to preserve the total count while handling negatives
\item You need a delay distribution that sums to 1 or a CDF that is weakly
increasing
}

Do not use this function when:
\itemize{
\item Your data naturally has negative PMF entries (e.g., from differencing)
\item You want to preserve the original structure including negatives
\item You are working with corrections that should be reflected as negative
probabilities
}
}
\examples{
# Using example dataset with negative values from corrections
# Preprocess to handle negatives
preprocessed <- preprocess_negative_values(example_downward_corr_rt)
preprocessed
}
\seealso{
Delay distribution estimation functions
\code{\link{estimate_delay}()}
}
\concept{estimate_delay}
