% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_predictions.R
\name{sample_nowcasts}
\alias{sample_nowcasts}
\title{Generate multiple draws of a nowcast combining observed and predicted values}
\usage{
sample_nowcasts(
  point_nowcast_matrix,
  reporting_triangle,
  uncertainty_params,
  draws = 1000,
  ...
)
}
\arguments{
\item{point_nowcast_matrix}{Matrix of point nowcast predictions and
observations, with rows representing the reference times and columns
representing the delays.}

\item{reporting_triangle}{A \link{reporting_triangle} object with rows
representing reference times and columns representing delays.
Can be a reporting matrix or incomplete reporting matrix.
Can also be a ragged reporting triangle, where multiple columns are
reported for the same row (e.g., weekly reporting of daily data).}

\item{uncertainty_params}{Vector of uncertainty parameters ordered from
horizon 1 to the maximum horizon. Note that these will be reversed
internally to match the ordering of the \code{point_nowcast_matrix} (where
a horizon of 1 is the last entry).}

\item{draws}{Integer indicating the number of draws of the predicted
nowcast vector to generate. Default is \code{1000}.}

\item{...}{Additional arguments passed to \code{sample_nowcast}.}
}
\value{
Dataframe containing information for multiple draws with columns
for the reference date (\code{reference_date}), the predicted counts
(\code{pred_count}), and the draw number (\code{draw}). Returns predictions for all
reference dates in the input \code{reporting_triangle} (or fewer if using
\code{ref_time_aggregator}).
}
\description{
Generate multiple draws of a nowcast combining observed and predicted values
}
\examples{
# Generate point nowcast and uncertainty params from example data
data_as_of <- syn_nssp_df[syn_nssp_df$report_date <= "2026-04-01", ]
rep_tri <- as_reporting_triangle(data_as_of) |>
  truncate_to_delay(max_delay = 5) |>
  tail(n = 10)
point_nowcast_matrix <- estimate_and_apply_delay(rep_tri, n = 10)
reporting_triangle <- apply_reporting_structure(rep_tri)
uncertainty_params <- estimate_uncertainty_retro(
  rep_tri,
  n_history_delay = 8,
  n_retrospective_nowcasts = 2
)
nowcast_draws <- sample_nowcasts(
  point_nowcast_matrix,
  reporting_triangle,
  uncertainty_params,
  draws = 5
)
nowcast_draws
}
\seealso{
Probabilistic nowcast generation functions
\code{\link{combine_obs_with_pred}()},
\code{\link{sample_nb}()},
\code{\link{sample_nowcast}()},
\code{\link{sample_prediction}()},
\code{\link{sample_predictions}()}
}
\concept{generate_probabilistic_nowcasts}
