% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrgamsp.R
\name{shrgamsp}
\alias{shrgamsp}
\title{Cox PH model with univariate and bivariate shared gamma frailty model.}
\usage{
shrgamsp(
  formula,
  data,
  weights = NULL,
  initfrailp = NULL,
  control = bcfrailph.control(),
  ...
)
}
\arguments{
\item{formula}{A formula object, with the response on the left of a ~ operator, and the terms on the right. The response must be a survival object as returned by the \code{Surv} function.}

\item{data}{A dataframe contain survival time, censor, covariate etc with data in columns.}

\item{weights}{vector of case weights for gamma model. the default is NULL.}

\item{initfrailp}{Initial estimates for the frailty parameters. The default is c(0.5).}

\item{control}{Arguments to control the fit. The default is \code{\link{bcfrailph.control}}.}

\item{...}{further arguments}
}
\value{
An object of shrgamsp contains  the following components.
\itemize{
  \item \code{coefficients} - A vector of estimated Covariate coefficients.
  \item \code{frailparest} - A vector of estimated Frailty parameters i.e. frailty variance and correlation.
  \item \code{vcov}- Variance Covariance matrix of the Estimated Covariate coefficients obtained from the observed information matrix.
  \item \code{stderr}-A vector containing the Standard error of the Estimated parameters both covariate coefficients and  frailty parameter.
  \item \code{loglik0}- Log likelihood of without frailty model.
  \item \code{loglik}-Log likelihood of Cox PH model with frailty.
  \item \code{Iloglilk}- Log likelihood of with frailty model after integrating out the frailty term.
  \item \code{bhaz}- an array containing unique event times and estimated baseline hazard.
  \item \code{X}-Matrix of observed covariates.
  \item \code{time}-the observed survival time.
  \item \code{censor}-censoring indicator.
  \item \code{resid}-the martingale residuals.
  \item \code{lin.prid}-the vector of linear predictors.
  \item \code{frail}-estimated Frailty values.
  \item \code{iteration}-Number of outer iterations.
  \item \code{e.time}-the vector of unique event times.
  \item \code{n.event}- the number of events at each of the unique event times.
  \item \code{convergence}-an indicator of convergence . see \code{\link{nlminb}}.
  }
}
\description{
Fit Cox PH model with univariate and bivariate shared gamma frailty model.
}
\note{
This is just a \code{coxph} model with gamma frailty and the differences between
\code{coxph} with gamma frailty fit and \code{\link{shrgamsp}} fit is on the standard errors of the
covariates cofficients. Here, the standard errors of the estimated covariate coefficients and the frailty variance parameter are obtained using
the standard errors estimation approach given in Klein and Moeschberger (2003).
}
\examples{
set.seed(2)
n1=500;IID=array(1:n1)
X1<-runif(n1,  min=0, max=1)
z=rgamma(n1,shape=2,scale=0.5)
u1<-runif(n1,  min=0, max=1)
time<- 1/0.1*log(1-0.1*log(u1)/(0.0001*exp(3*X1)*z))
censor=rep(1,n1)
dataa <- data.frame(time=time, X1=X1,censor=censor,IID=IID)

fitcoxfr=shrgamsp(Surv(time,censor)~ X1+frailty(IID) ,data=dataa)
fitcoxfr

}
\references{
Duchateau, L., Janssen, P. (2008) The Frailty Model. Springer, New York.

Klein, J. P., and Moeschberger, M. L. (2003), Survival analysis: techniques for censored and truncated data, New York: Springer.
}
\seealso{
\code{\link{bcfrailph}}
}
