% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_documents_3d.R
\name{visualize_documents_3d}
\alias{visualize_documents_3d}
\title{Visualize Documents in 3D Space using BERTopic}
\usage{
visualize_documents_3d(
  model,
  texts,
  reduced_embeddings,
  custom_labels = FALSE,
  hide_annotation = TRUE,
  tooltips = c("Topic", "Name", "Probability", "Text"),
  filename = "visualize_documents_3d",
  auto_open = FALSE
)
}
\arguments{
\item{model}{A BERTopic model object. Default is 'topic_model'.}

\item{texts}{A character vector or list of cleaned text documents to visualize.}

\item{reduced_embeddings}{A matrix or data frame of reduced-dimensionality embeddings (3D). Typically generated using UMAP.}

\item{custom_labels}{Logical. If TRUE, custom topic labels are used. Default is FALSE.}

\item{hide_annotation}{Logical. If TRUE, hides annotations on the plot. Default is TRUE.}

\item{tooltips}{A character vector of tooltips for hover information. Default is c("Topic", "Name", "Probability", "Text").}

\item{filename}{A character string specifying the name of the HTML file to save the visualization. Default is "visualize_documents_3d".
The \code{.html} extension is automatically added if not provided.}

\item{auto_open}{Logical. If TRUE, opens the HTML file in the browser after saving. Default is FALSE.}
}
\value{
The function does not return a value but saves an HTML file containing the visualization
and displays it in the current R environment.
}
\description{
This function generates a 3D visualization of documents using a pre-trained BERTopic model and UMAP dimensionality reduction.
It uses Plotly for interactive visualizations and saves the output as an HTML file.
}
\examples{
\donttest{
if (exists("topic_model") && exists("texts_cleaned") && exists("embeddings")) {
  visualize_documents_3d(model = topic_model,
    texts = texts_cleaned,
    reduced_embeddings = embeddings,
    custom_labels = FALSE,
    hide_annotation = TRUE,
    filename = "plot",
    auto_open = TRUE)
} else {
  message("Missing topic_model/texts_cleaned/embeddings. Train a model first.")
}
}
}

