% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netclu_oslom.R
\name{netclu_oslom}
\alias{netclu_oslom}
\title{OSLOM community finding}
\usage{
netclu_oslom(
  net,
  weight = TRUE,
  cut_weight = 0,
  index = names(net)[3],
  seed = NULL,
  reassign = "no",
  r = 10,
  hr = 50,
  t = 0.1,
  cp = 0.5,
  directed = FALSE,
  bipartite = FALSE,
  site_col = 1,
  species_col = 2,
  return_node_type = "both",
  binpath = "tempdir",
  check_install = TRUE,
  path_temp = "oslom_temp",
  delete_temp = TRUE
)
}
\arguments{
\item{net}{The output object from \code{\link[=similarity]{similarity()}} or
\code{\link[=dissimilarity_to_similarity]{dissimilarity_to_similarity()}}.
If a \code{data.frame} is used, the first two columns represent pairs of
sites (or any pair of nodes), and the next column(s) are the similarity
indices.}

\item{weight}{A \code{boolean} indicating if the weights should be considered
if there are more than two columns.}

\item{cut_weight}{A minimal weight value. If \code{weight} is TRUE, the links
between sites with a weight strictly lower than this value will not be
considered (0 by default).}

\item{index}{Name or number of the column to use as weight. By default,
the third column name of \code{net} is used.}

\item{seed}{For the random number generator (NULL for random by default).}

\item{reassign}{A \code{character} indicating if the nodes belonging to several
community should be reassigned and what method should be used (see Note).}

\item{r}{The number of runs for the first hierarchical level
(10 by default).}

\item{hr}{The number of runs for the higher hierarchical level (50 by
default, 0 if you are not interested in hierarchies).}

\item{t}{The p-value, the default value is 0.10. Increase this value if you want
more modules.}

\item{cp}{Kind of resolution parameter used to decide between taking some
modules or their union (default value is 0.5; a bigger value leads to bigger
clusters).}

\item{directed}{A \code{boolean} indicating if the network is directed (from
column 1 to column 2).}

\item{bipartite}{A \code{boolean} indicating if the network is bipartite
(see Details).}

\item{site_col}{Name or number for the column of site nodes
(i.e. primary nodes).}

\item{species_col}{Name or number for the column of species nodes
(i.e. feature nodes).}

\item{return_node_type}{A \code{character} indicating what types of nodes
(\code{site}, \code{species}, or \code{both}) should be returned in the output
(\code{return_node_type = "both"} by default).}

\item{binpath}{A \code{character} indicating the path to the bin folder
(see \link{install_binaries} and Details).}

\item{check_install}{A \code{boolean} indicating if the function should check that
the OSLOM has been properly installed (see \link{install_binaries} and Details).}

\item{path_temp}{A \code{character} indicating the path to the temporary folder
(see Details).}

\item{delete_temp}{A \code{boolean} indicating if the temporary folder should
be removed (see Details).}
}
\value{
A \code{list} of class \code{bioregion.clusters} with five slots:
\enumerate{
\item{\strong{name}: A \code{character} containing the name of the algorithm.}
\item{\strong{args}: A \code{list} of input arguments as provided by the user.}
\item{\strong{inputs}: A \code{list} of characteristics of the clustering process.}
\item{\strong{algorithm}: A \code{list} of all objects associated with the
clustering procedure, such as original cluster objects (only if
\code{algorithm_in_output = TRUE}).}
\item{\strong{clusters}: A \code{data.frame} containing the clustering results.}}

In the \code{algorithm} slot, users can find the following elements:

\itemize{
\item{\code{cmd}: The command line used to run OSLOM.}
\item{\code{version}: The OSLOM version.}
\item{\code{web}: The OSLOM's web site.}
}
}
\description{
This function finds communities in a (un)weighted (un)directed network based
on the OSLOM algorithm (\url{http://oslom.org/}, version 2.4).
}
\details{
OSLOM is a network community detection algorithm proposed in
Lancichinetti et al. (2011) that finds statistically significant
(overlapping) communities in (un)weighted and (un)directed networks.

This function is based on the 2.4 C++ version of OSLOM
(\url{http://www.oslom.org/software.htm}). This function needs files
to run. They can be installed with \link{install_binaries}.

\strong{If you changed the default path to the \code{bin} folder
while running \link{install_binaries}, PLEASE MAKE SURE to set \code{binpath}
accordingly.}

\strong{If you did not use \link{install_binaries} to change the permissions and test
the binary files, PLEASE MAKE SURE to set \code{check_install} accordingly.}

The C++ version of OSLOM generates temporary folders and/or files that are
stored in the \code{path_temp} folder (folder "oslom_temp" with a unique timestamp
located in the bin folder in \code{binpath} by default). This temporary folder is
removed by default (\code{delete_temp = TRUE}).
}
\note{
Although this algorithm was not primarily designed to deal with bipartite
networks, it is possible to consider the bipartite network as unipartite
network (\code{bipartite = TRUE}). Do not forget to indicate which of the
first two columns is dedicated to the site nodes (i.e. primary nodes) and
species nodes (i.e. feature nodes) using the arguments \code{site_col} and
\code{species_col}. The type of nodes returned in the output can be chosen
with the argument \code{return_node_type} equal to \code{both} to keep both
types of nodes, \code{sites} to preserve only the sites nodes, and
\code{species} to preserve only the species nodes.

Since OSLOM potentially returns overlapping communities, we propose two
methods to reassign the 'overlapping' nodes: randomly (\code{reassign = "random"})
or based on the closest candidate community (\code{reassign = "simil"}) (only for
weighted networks, in this case the closest candidate community is
determined with the average similarity). By default, \code{reassign = "no"} and
all the information will be provided. The number of partitions will depend
on the number of overlapping modules (up to three). The suffix \verb{_semel},
\verb{_bis}, and \verb{_ter} are added to the column names. The first partition
(\verb{_semel}) assigns a module to each node. A value of \code{NA} in the second
(\verb{_bis}) and third (\verb{_ter}) columns indicates that no overlapping module
was found for this node (i.e. non-overlapping nodes).
}
\examples{
comat <- matrix(sample(1000, 50), 5, 10)
rownames(comat) <- paste0("Site", 1:5)
colnames(comat) <- paste0("Species", 1:10)

net <- similarity(comat, metric = "Simpson")
com <- netclu_oslom(net)

}
\references{
Lancichinetti A, Radicchi F, Ramasco JJ & Fortunato S (2011) Finding
statistically significant communities in networks. \emph{PLOS ONE} 6,
e18961.
}
\seealso{
For more details illustrated with a practical example,
see the vignette:
\url{https://biorgeo.github.io/bioregion/articles/a4_3_network_clustering.html}.

Associated functions:
\link{netclu_greedy} \link{netclu_infomap} \link{netclu_louvain}
}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr}) \cr
Pierre Denelle (\email{pierre.denelle@gmail.com}) \cr
Boris Leroy (\email{leroy.boris@gmail.com})
}
