% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractor.R
\name{add_sheet}
\alias{add_sheet}
\title{Add a worksheet to an Excel workbook with flexible content}
\usage{
add_sheet(name, df)
}
\arguments{
\item{name}{Character scalar; name of the worksheet to add.}

\item{df}{Either a data frame to write directly, or a list whose
elements can be data frames, lists of data frames, or arbitrary
R objects. Non-data-frame objects are written using the output of
\code{str()}.}
}
\value{
Invisibly returns \code{NULL}. The workbook \code{wb} is
modified in place.
}
\description{
Convenience helper that adds a worksheet to a global workbook
object and writes either a single data frame, or a nested list of
objects (data frames or other structures) in a readable layout.
}
\details{
This function assumes that a global \code{wb} object exists (an
\pkg{openxlsx} workbook). When \code{df} is a list, it iterates over
list elements and writes labeled sections for each element and its
sub-elements.

If \code{df} is \code{NULL}, a one-row data frame with the message
\code{"Sin datos"} is written.
}
\keyword{internal}
