% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rootfinding_and_minimisation.R
\name{rootfinding_and_minimisation}
\alias{rootfinding_and_minimisation}
\alias{bisect}
\alias{bracket_and_solve_root}
\alias{toms748_solve}
\alias{newton_raphson_iterate}
\alias{halley_iterate}
\alias{schroder_iterate}
\alias{brent_find_minima}
\title{Root-Finding and Minimisation Functions}
\usage{
bisect(
  f,
  lower,
  upper,
  digits = .Machine$double.digits,
  max_iter = .Machine$integer.max
)

bracket_and_solve_root(
  f,
  guess,
  factor,
  rising,
  digits = .Machine$double.digits,
  max_iter = .Machine$integer.max
)

toms748_solve(
  f,
  lower,
  upper,
  digits = .Machine$double.digits,
  max_iter = .Machine$integer.max
)

newton_raphson_iterate(
  f,
  guess,
  lower,
  upper,
  digits = .Machine$double.digits,
  max_iter = .Machine$integer.max
)

halley_iterate(
  f,
  guess,
  lower,
  upper,
  digits = .Machine$double.digits,
  max_iter = .Machine$integer.max
)

schroder_iterate(
  f,
  guess,
  lower,
  upper,
  digits = .Machine$double.digits,
  max_iter = .Machine$integer.max
)

brent_find_minima(
  f,
  lower,
  upper,
  digits = .Machine$double.digits,
  max_iter = .Machine$integer.max
)
}
\arguments{
\item{f}{A function to find the root of or to minimise. It should take and return a single numeric value for root-finding, or a numeric vector for minimisation.}

\item{lower}{The lower bound of the interval to search for the root or minimum.}

\item{upper}{The upper bound of the interval to search for the root or minimum.}

\item{digits}{The number of significant digits to which the root or minimum should be found. Defaults to double precision.}

\item{max_iter}{The maximum number of iterations to perform. Defaults to the maximum integer value.}

\item{guess}{A numeric value that is a guess for the root or minimum.}

\item{factor}{Size of steps to take when searching for the root.}

\item{rising}{If TRUE, the function is assumed to be rising, otherwise it is assumed to be falling.}
}
\value{
A list containing the root or minimum value, the value of the function at that point, and the number of iterations performed.
}
\description{
Functions for root-finding and minimisation using various algorithms.
}
\details{
This package provides a set of functions for finding roots of equations and minimising functions using different numerical methods. The methods include bisection, bracket and solve, TOMS
748, Newton-Raphson, Halley's method, Schroder's method, and Brent's method. It also includes functions for finding roots of polynomials (quadratic, cubic, quartic) and computing minima.
}
\examples{
f <- function(x) x^2 - 2
bisect(f, lower = 0, upper = 2)
bracket_and_solve_root(f, guess = 1, factor = 0.1, rising = TRUE)
toms748_solve(f, lower = 0, upper = 2)
f <- function(x) c(x^2 - 2, 2 * x)
newton_raphson_iterate(f, guess = 1, lower = 0, upper = 2)
f <- function(x) c(x^2 - 2, 2 * x, 2)
halley_iterate(f, guess = 1, lower = 0, upper = 2)
schroder_iterate(f, guess = 1, lower = 0, upper = 2)
f <- function(x) (x - 2)^2 + 1
brent_find_minima(f, lower = 0, upper = 4)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/root_finding.html}{Boost Documentation} for more details on the mathematical background.
}
