% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{db_query_create}
\alias{db_query_create}
\title{Create a SQL Query}
\usage{
db_query_create(
  warehouse_id,
  query_text,
  display_name,
  description = NULL,
  catalog = NULL,
  schema = NULL,
  parent_path = NULL,
  run_as_mode = c("OWNER", "VIEWER"),
  apply_auto_limit = FALSE,
  auto_resolve_display_name = TRUE,
  tags = list(),
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{warehouse_id}{description}

\item{query_text}{Text of the query to be run.}

\item{display_name}{Display name of the query that appears in list views,
widget headings, and on the query page.}

\item{description}{General description that conveys additional information
about this query such as usage notes.}

\item{catalog}{Name of the catalog where this query will be executed.}

\item{schema}{Name of the schema where this query will be executed.}

\item{parent_path}{Workspace path of the workspace folder containing the object.}

\item{run_as_mode}{Sets the "Run as" role for the object.}

\item{apply_auto_limit}{Whether to apply a 1000 row limit to the query result.}

\item{auto_resolve_display_name}{Automatically resolve query display name
conflicts. Otherwise, fail the request if the query's display name conflicts
with an existing query's display name.}

\item{tags}{Named list that describes the warehouse. Databricks tags all
warehouse resources with these tags.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Create a SQL Query
}
\seealso{
Other SQL Queries API: 
\code{\link{db_query_delete}()},
\code{\link{db_query_get}()},
\code{\link{db_query_list}()},
\code{\link{db_query_update}()}
}
\concept{SQL Queries API}
