% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calba.R
\name{ba_decay_long}
\alias{ba_decay_long}
\title{Long-format decay table}
\usage{
ba_decay_long(
  mu_values,
  sp,
  gx,
  gy,
  ba,
  r,
  exponential_normal = FALSE,
  edge_correction = c("none", "safe"),
  bounds = NULL
)
}
\arguments{
\item{mu_values}{Numeric vector of decay parameters.}

\item{sp}{Character/factor species vector.}

\item{gx}{Numeric x-coordinates.}

\item{gy}{Numeric y-coordinates.}

\item{ba}{Numeric basal area.}

\item{r}{Positive radius threshold.}

\item{exponential_normal}{Logical passed to `ba_decay`.}

\item{edge_correction}{Character; see `ba_simple()` for the `"safe"` option.}

\item{bounds}{Optional numeric vector `c(xmin, xmax, ymin, ymax)` giving the plot extent.
When `NULL`, the range of `gx`/`gy` is used; supply bounds if your data do not span the full plot.}
}
\value{
A data frame with `tree_id`, `species`, `mu`, `con_ba`, and `total_ba`.
}
\description{
Transform the matrices returned by `ba_decay` into a tidy table that can be
joined with other data or mapped with `ggplot2`.
}
