% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R
\name{svg_card}
\alias{svg_card}
\title{Create an Information Card in SVG Format}
\usage{
svg_card(
  title = "FAR",
  badges_data = list(),
  fields = list(),
  bg_color = "#fab255",
  width = 500,
  padding = 20,
  corner_radius = 8,
  font = "Jost",
  title_fontsize = 16,
  title_color = "white",
  label_fontsize = 11,
  value_fontsize = 11,
  label_color = "white",
  value_bg_color = "#f8f8ff",
  value_text_color = "#212529",
  show_house_icon = TRUE,
  logos = list(),
  logos_height = 40,
  bottom_logos = list(),
  bottom_logos_height = 30,
  footer = NULL,
  gap_to_footer = 6,
  footer_row_padding_bottom = 6,
  footer_fontsize = 8,
  footer_color = "white",
  uniform_row_height = TRUE,
  show_viewer = interactive()
)
}
\arguments{
\item{title}{Card title (e.g., "FAR", "FNHIS")}

\item{badges_data}{List of badge data (label, value, color)}

\item{fields}{List of field rows, each row is a list of fields with label, value,
and optionally with_icon. The with_icon parameter can be:
\itemize{
\item TRUE - uses the default house icon
\item FALSE or NULL - no icon
\item A character string - path to an SVG file or raw SVG code
}}

\item{bg_color}{Background color of the card}

\item{width}{Card width in pixels}

\item{padding}{Padding inside the card}

\item{corner_radius}{Corner radius for rounded corners}

\item{font}{Font family}

\item{title_fontsize}{Title font size}

\item{title_color}{Color for the card title (default "white")}

\item{label_fontsize}{Label font size}

\item{value_fontsize}{Value font size}

\item{label_color}{Color for field labels (default "white")}

\item{value_bg_color}{Background color for value boxes}

\item{value_text_color}{Text color for values}

\item{show_house_icon}{Show house icon next to empreendimento}

\item{logos}{Character vector of logo file paths or SVG strings for top right.
Use \code{get_svg_path("filename.svg")} for bundled logos, or any local path.}

\item{logos_height}{Height for top-right logos (default 40)}

\item{bottom_logos}{Character vector of logo file paths or SVG strings for bottom left.}

\item{bottom_logos_height}{Height for bottom-left logos (default 30)}

\item{footer}{Footer text (e.g., update timestamp)}

\item{gap_to_footer}{Distance (px) between the last info block and the footer row.}

\item{footer_row_padding_bottom}{Bottom padding (px) under the footer row (text + logos).}

\item{footer_fontsize}{Footer font size}

\item{footer_color}{Color for footer text (default "white")}

\item{uniform_row_height}{If TRUE, keep the height inside a row.}

\item{show_viewer}{If TRUE (and interactive), preview the SVG in the Viewer.}
}
\value{
SVG string
}
\description{
Generate a complete information card as an SVG with embedded styles,
fonts, badges, logos, and field labels/values.
}
\examples{
# With default house icon
fields <- list(
  list(
    list(label = "Empreendimento", value = "CAIARA II", with_icon = TRUE)
  )
)

# With custom icon
custom_icon <- '<svg width="50" height="50"><circle cx="25" cy="25" r="20" fill="white"/></svg>'
fields <- list(
  list(
    list(label = "Projeto", value = "Meu Projeto", with_icon = custom_icon)
  )
)

badges <- list(
  list(label = "UH", value = "192"),
  list(label = "Recurso Federal", value = "36,4 milhões")
)

# With file paths for logos
svg_card("FAR", badges, fields, 
         bg_color = "#fab255",
         logos = c("path/to/logo1.svg", "path/to/logo2.svg"),
         bottom_logos = c("path/to/gov_logo.svg"))
}
