test_that("use esm", {
  sa <- sdm_area(parana, 1)
  sa <- add_predictors(sa, bioc)
  sa <- dplyr::select(sa, c("bio1", "bio12"))
  oc <- occurrences_sdm(occ, crs=6933)
  oc <- join_area(oc, sa)
  i <- input_sdm(oc, sa)
  expect_error(use_esm(i))
  expect_error(use_esm(i, spp = "1"))
  expect_error(use_esm(i, n_records = "a"))
  expect_error(use_esm(i, n_records = 1))

  i1 <- use_esm(i, spp = "Araucaria angustifolia")
  i2 <- use_esm(i, n_records = 999)

  expect_true("esm" %in% names(i1$occurrences))
  expect_true("esm" %in% names(i2$occurrences))
  expect_true(all(c("n_records", "spp") %in% names(i1$occurrences$esm)))
  expect_true(all(c("n_records", "spp") %in% names(i2$occurrences$esm)))
  expect_true("Araucaria angustifolia" %in% i1$occurrences$esm$spp)
  expect_true("Araucaria angustifolia" %in% i2$occurrences$esm$spp)
  expect_true(i1$occurrences$esm$n_records == 20)
  expect_true(i2$occurrences$esm$n_records == 999)
})
