% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{aid}
\alias{aid}
\title{Adjustment Identification Distance}
\usage{
aid(truth, guess, type = c("oset", "ancestor", "parent"), normalized = TRUE)
}
\arguments{
\item{truth}{A \code{caugi} object.}

\item{guess}{A \code{caugi} object.}

\item{type}{A character string specifying the type of AID to compute.
Options are \code{"oset"} (default), \code{"ancestor"}, and \code{"parent"}.}

\item{normalized}{Logical; if \code{TRUE}, returns the normalized AID. If \code{FALSE},
returns the count.}
}
\value{
A numeric representing the AID between the two graphs, if
\code{normalized = TRUE}, or an integer count if \code{normalized = FALSE}.
}
\description{
Compute the Adjustment Identification Distance (AID) between two
graphs using the \code{gadjid} Rust package.
}
\examples{
set.seed(1)
truth <- generate_graph(n = 100, m = 200, class = "DAG")
guess <- generate_graph(n = 100, m = 200, class = "DAG")
aid(truth, guess) # 0.0187

}
\seealso{
Other metrics: 
\code{\link{hd}()},
\code{\link{shd}()}
}
\concept{metrics}
