# modified from the python library faker:
# https://github.com/joke2k/faker/blob/master/faker/providers/person/fr_FR/__init__.py

person_formats_female_fr_fr <- c(
  "{{first_names_female}} {{last_names}}",
  "{{first_names_female}} {{last_names}}",
  "{{first_names_female}} {{last_names}}",
  "{{first_names_female}} {{last_names}}",
  "{{first_names_female}} {{last_names}}",
  "{{first_names_female}} {{last_names}}",
  "{{first_names_female}} {{prefixes}}{{last_names}}",
  "{{first_names_female}} {{last_names1}}-{{last_names2}}",
  "{{first_names_female1}}-{{first_names_female2}} {{last_names}}",
  "{{first_names_female}} {{last_names1}} {{prefixes}}{{last_names2}}"
)

person_formats_male_fr_fr <- c(
  "{{first_names_male}} {{last_names}}",
  "{{first_names_male}} {{last_names}}",
  "{{first_names_male}} {{last_names}}",
  "{{first_names_male}} {{last_names}}",
  "{{first_names_male}} {{last_names}}",
  "{{first_names_male}} {{last_names}}",
  "{{first_names_male}} {{prefixes}}{{last_names}}",
  "{{first_names_male}} {{last_names1}}-{{last_names2}}",
  "{{first_names_male1}}-{{first_names_male2}} {{last_names}}",
  "{{first_names_male}} {{last_names1}} {{prefixes}}{{last_names2}}"
)

person_formats_fr_fr <- c(person_formats_male_fr_fr, person_formats_female_fr_fr)

person_first_names_male_fr_fr <- c(
  "Adrien",
  "Aim\u00e9",
  "Alain",
  "Alexandre",
  "Alfred",
  "Alphonse",
  "Andr\u00e9",
  "Antoine",
  "Arthur",
  "Auguste",
  "Augustin",
  "Benjamin",
  "Beno\u00eet",
  "Bernard",
  "Bertrand",
  "Charles",
  "Christophe",
  "Daniel",
  "David",
  "Denis",
  "\u00c9douard",
  "\u00c9mile",
  "Emmanuel",
  "\u00c9ric",
  "\u00c9tienne",
  "Eug\u00e8ne",
  "Fran\u00e7ois",
  "Franck",
  "Fr\u00e9d\u00e9ric",
  "Gabriel",
  "Georges",
  "G\u00e9rard",
  "Gilbert",
  "Gilles",
  "Gr\u00e9goire",
  "Guillaume",
  "Guy",
  "William",
  "Henri",
  "Honor\u00e9",
  "Hugues",
  "Isaac",
  "Jacques",
  "Jean",
  "J\u00e9r\u00f4me",
  "Joseph",
  "Jules",
  "Julien",
  "Laurent",
  "L\u00e9on",
  "Louis",
  "Luc",
  "Lucas",
  "Marc",
  "Marcel",
  "Martin",
  "Matthieu",
  "Maurice",
  "Michel",
  "Nicolas",
  "No\u00ebl",
  "Olivier",
  "Patrick",
  "Paul",
  "Philippe",
  "Pierre",
  "Raymond",
  "R\u00e9my",
  "Ren\u00e9",
  "Richard",
  "Robert",
  "Roger",
  "Roland",
  "S\u00e9bastien",
  "St\u00e9phane",
  "Th\u00e9odore",
  "Th\u00e9ophile",
  "Thibaut",
  "Thibault",
  "Thierry",
  "Thomas",
  "Timoth\u00e9e",
  "Tristan",
  "Victor",
  "Vincent",
  "Xavier",
  "Yves",
  "Zacharie"
)

person_first_names_female_fr_fr <- c(
  "Ad\u00e9la\u00efde",
  "Ad\u00e8le",
  "Adrienne",
  "Agathe",
  "Agn\u00e8s",
  "Aim\u00e9e",
  "Alexandrie",
  "Alix",
  "Alexandria",
  "Alex",
  "Alice",
  "Am\u00e9lie",
  "Ana\u00efs",
  "Anastasie",
  "Andr\u00e9e",
  "Anne",
  "Anouk",
  "Antoinette",
  "Arnaude",
  "Astrid",
  "Audrey",
  "Aur\u00e9lie",
  "Aurore",
  "Bernadette",
  "Brigitte",
  "Capucine",
  "Caroline",
  "Catherine",
  "C\u00e9cile",
  "C\u00e9line",
  "C\u00e9lina",
  "Chantal",
  "Charlotte",
  "Christelle",
  "Christiane",
  "Christine",
  "Claire",
  "Claudine",
  "Cl\u00e9mence",
  "Colette",
  "Constance",
  "Corinne",
  "Danielle",
  "Denise",
  "Diane",
  "Doroth\u00e9e",
  "\u00c9dith",
  "\u00c9l\u00e9onore",
  "\u00c9lisabeth",
  "\u00c9lise",
  "\u00c9lodie",
  "\u00c9milie",
  "Emmanuelle",
  "Fran\u00e7oise",
  "Fr\u00e9d\u00e9rique",
  "Gabrielle",
  "Genevi\u00e8ve",
  "H\u00e9l\u00e8ne",
  "Henriette",
  "Hortense",
  "In\u00e8s",
  "Isabelle",
  "Jacqueline",
  "Jeanne",
  "Jeannine",
  "Jos\u00e9phine",
  "Josette",
  "Julie",
  "Juliette",
  "Laetitia",
  "Laure",
  "Laurence",
  "Lorraine",
  "Louise",
  "Luce",
  "Lucie",
  "Lucy",
  "Madeleine",
  "Manon",
  "Marcelle",
  "Margaux",
  "Margaud",
  "Marguerite",
  "Margot",
  "Margaret",
  "Maggie",
  "daisy",
  "Marianne",
  "Marie",
  "Marine",
  "Marthe",
  "Martine",
  "Maryse",
  "Mathilde",
  "Mich\u00e8le",
  "Michelle",
  "Monique",
  "Nath",
  "Nathalie",
  "Nicole",
  "No\u00e9mi",
  "Oc\u00e9ane",
  "Odette",
  "Olivie",
  "Patricia",
  "Paulette",
  "Pauline",
  "P\u00e9n\u00e9lope",
  "Philippine",
  "Ren\u00e9e",
  "Sabine",
  "Simone",
  "Sophie",
  "St\u00e9phanie",
  "Susanne",
  "Susan",
  "Suzanne",
  "Sylvie",
  "Th\u00e9r\u00e8se",
  "Valentine",
  "Val\u00e9rie",
  "V\u00e9ronique",
  "Victoire",
  "Virginie",
  "Zo\u00e9",
  "Camille",
  "Claude",
  "Dominique"
)

person_first_names_fr_fr <- c(person_first_names_male_fr_fr, person_first_names_female_fr_fr)

person_last_names_fr_fr <- c(
  "Adam",
  "Albert",
  "Alexandre",
  "Allain",
  "Allard",
  "Alves",
  "Andr\u00e9",
  "Antoine",
  "Arnaud",
  "Aubry",
  "Aub\u00e9rt",
  "Auger",
  "Bailly",
  "Barbe",
  "Barbi\u00e9r",
  "Baron",
  "Barr\u00e9",
  "Barthelemy",
  "Baudry",
  "Bazin",
  "Becker",
  "Begue",
  "Benard",
  "Berg\u00e9r",
  "Bernier",
  "Berthelot",
  "Bertin",
  "Besnard",
  "Besson",
  "Bigot",
  "Blanc",
  "Blanchard",
  "Blanchet",
  "Blin",
  "Blondel",
  "Blot",
  "Bodin",
  "Bonneau",
  "Bonnin",
  "Bonn\u00e9t",
  "Boucher",
  "Bouchet",
  "Boulanger",
  "Boulay",
  "Bourdon",
  "Bourg\u00e9ois",
  "Bousquet",
  "Boutin",
  "Bouvet",
  "Bouvier",
  "Boy\u00e9r",
  "Briand",
  "Br\u00e9ton",
  "Brun",
  "Bruneau",
  "Brunel",
  "Brun\u00e9t",
  "B\u00e9noit",
  "B\u00e9rnard",
  "B\u00e9rtrand",
  "Buisson",
  "Camus",
  "Carlier",
  "Caron",
  "Carp\u00e9ntier",
  "Carr\u00e9",
  "Charl\u00e9s",
  "Charp\u00e9ntier",
  "Charrier",
  "Chartier",
  "Chauveau",
  "Chauvet",
  "Chauvin",
  "Chevali\u00e9r",
  "Chevallier",
  "Chretien",
  "Clem\u00e9nt",
  "Clerc",
  "Cohen",
  "Colas",
  "Colin",
  "Collin",
  "Coll\u00e9t",
  "Cordier",
  "Costa",
  "Coste",
  "Coulon",
  "Courtois",
  "Cousin",
  "Couturier",
  "Daniel",
  "David",
  "Delahaye",
  "Delannoy",
  "Delattre",
  "Delaunay",
  "Delmas",
  "Delorme",
  "Denis",
  "Descamps",
  "Devaux",
  "Diallo",
  "Dias",
  "Diaz",
  "Didier",
  "Dijoux",
  "D\u00e9schamps",
  "Dubois",
  "Dufour",
  "Duhamel",
  "Dumas",
  "Dumont",
  "Dupont",
  "Dupre",
  "Dupuis",
  "Dupuy",
  "Durand",
  "Duval",
  "Etienne",
  "Evrard",
  "Fabr\u00e9",
  "Faivre",
  "Faur\u00e9",
  "Fernandes",
  "Fernand\u00e9z",
  "Ferrand",
  "Ferreira",
  "Fischer",
  "Fl\u00e9ury",
  "Fontain\u00e9",
  "Foucher",
  "Fouquet",
  "Fourni\u00e9r",
  "Francois",
  "Gaillard",
  "Gall",
  "Gallet",
  "Garcia",
  "Garni\u00e9r",
  "Gaudin",
  "Gauthi\u00e9r",
  "Gauti\u00e9r",
  "Gay",
  "Georges",
  "Germain",
  "Gilbert",
  "Gilles",
  "Gillet",
  "Gimenez",
  "Girard",
  "Giraud",
  "Godard",
  "Goff",
  "Gomes",
  "Gomez",
  "Goncalves",
  "Gonzal\u00e9z",
  "Gosselin",
  "Gregoire",
  "Grenier",
  "Grondin",
  "Gros",
  "G\u00e9rard",
  "Guibert",
  "Guichard",
  "Guilbert",
  "Guillaume",
  "Guillet",
  "Guillon",
  "Guillot",
  "Guillou",
  "Gu\u00e9rin",
  "Guyon",
  "Guyot",
  "Hamel",
  "Hamon",
  "Hardy",
  "Hebert",
  "Hernandez",
  "Herve",
  "Hoarau",
  "Hoareau",
  "H\u00e9nry",
  "Hub\u00e9rt",
  "Humbert",
  "Hu\u00e9t",
  "Imbert",
  "Jacob",
  "Jacques",
  "Jacquot",
  "Jacqu\u00e9t",
  "Joly",
  "Joseph",
  "Joubert",
  "Jourdan",
  "J\u00e9an",
  "Juli\u00e9n",
  "Klein",
  "Labbe",
  "Lacombe",
  "Lacroix",
  "Lagarde",
  "Laine",
  "Lamb\u00e9rt",
  "Lamy",
  "Langlois",
  "Laporte",
  "Laroche",
  "Launay",
  "Laur\u00e9nt",
  "Leblanc",
  "Lebon",
  "Lebreton",
  "Lebrun",
  "Lecl\u00e9rc",
  "Lecl\u00e9rcq",
  "Lecomt\u00e9",
  "Leconte",
  "Lecoq",
  "Ledoux",
  "Leduc",
  "Lefort",
  "Lef\u00e9vre",
  "Legendre",
  "Leger",
  "Legros",
  "Lejeune",
  "Leleu",
  "Lelievre",
  "Lemair\u00e9",
  "Lemaitre",
  "Lemoin\u00e9",
  "Lemonnier",
  "Lenoir",
  "Leroux",
  "Lesage",
  "Letellier",
  "Leveque",
  "Levy",
  "Loiseau",
  "Lombard",
  "Lopes",
  "Lop\u00e9z",
  "Louis",
  "L\u00e9grand",
  "L\u00e9roy",
  "L\u00e9v\u00eaque",
  "Lucas",
  "Mace",
  "Mahe",
  "Maillard",
  "Maillet",
  "Maillot",
  "Mallet",
  "Marchal",
  "Marchand",
  "Marechal",
  "Marin",
  "Marion",
  "Mari\u00e9",
  "Marques",
  "Martel",
  "Martin",
  "Martineau",
  "Martins",
  "Martin\u00e9z",
  "Marty",
  "Mary",
  "Masse",
  "Masson",
  "Mathi\u00e9u",
  "Maurice",
  "Maury",
  "Mendes",
  "Merci\u00e9r",
  "Merle",
  "Mey\u00e9r",
  "Michaud",
  "Mich\u00e9l",
  "Millet",
  "Monnier",
  "Moreno",
  "Morin",
  "Mor\u00e9au",
  "Mor\u00e9l",
  "Morvan",
  "Moulin",
  "M\u00e9nard",
  "M\u00e9unier",
  "Mull\u00e9r",
  "Munoz",
  "Navarro",
  "Neveu",
  "Nguyen",
  "Nicolas",
  "Normand",
  "No\u00e9l",
  "Oliveira",
  "Olivi\u00e9r",
  "Ollivier",
  "Pages",
  "Parent",
  "Paris",
  "Pascal",
  "Pasquier",
  "Paul",
  "Payet",
  "Pelletier",
  "Peltier",
  "Pereira",
  "Peron",
  "Perret",
  "Perrier",
  "Per\u00e9z",
  "Petitjean",
  "Philipp\u00e9",
  "Picard",
  "Pichon",
  "Pineau",
  "Pinto",
  "Pires",
  "Pi\u00e9rre",
  "Poiri\u00e9r",
  "Pons",
  "Potier",
  "Pottier",
  "Poulain",
  "Pr\u00e9vost",
  "Pruvost",
  "P\u00e9rrin",
  "P\u00e9rrot",
  "P\u00e9tit",
  "Ramos",
  "Raymond",
  "Raynaud",
  "Regnier",
  "Renaud",
  "Rey",
  "Reynaud",
  "Ribeiro",
  "Richard",
  "Riou",
  "Rivier\u00e9",
  "Robin",
  "Rob\u00e9rt",
  "Rocher",
  "Roch\u00e9",
  "Rodrigues",
  "Rodrigu\u00e9z",
  "Rog\u00e9r",
  "Rolland",
  "Rossi",
  "Rousset",
  "Rouss\u00e9au",
  "Rouss\u00e9l",
  "Roux",
  "Roy",
  "Roy\u00e9r",
  "R\u00e9my",
  "R\u00e9nard",
  "R\u00e9nault",
  "Ruiz",
  "Salmon",
  "Samson",
  "Sanch\u00e9z",
  "Santos",
  "Sauvage",
  "Schmitt",
  "Schneid\u00e9r",
  "Seguin",
  "Silva",
  "Simon",
  "Sousa",
  "Tanguy",
  "Techer",
  "Teixeira",
  "Tessier",
  "Texier",
  "Thibault",
  "Thierry",
  "Thomas",
  "Torres",
  "Toussaint",
  "Traore",
  "Turpin",
  "Vaillant",
  "Valentin",
  "Valette",
  "Vallee",
  "Vallet",
  "Vass\u00e9ur",
  "Verdier",
  "Vidal",
  "Vincent",
  "Voisin",
  "Wagner",
  "Weber",
  "Weiss"
)

person_prefixes_fr_fr <- c("d'", "L'")

person_fr_fr <- list(
  first_names = person_first_names_fr_fr,
  first_names_male = person_first_names_male_fr_fr,
  first_names_female = person_first_names_female_fr_fr,
  last_names = person_last_names_fr_fr,
  prefixes = person_prefixes_fr_fr
)


#' @title Person Provider for French (France)
#' @inherit PersonProvider description details return
#' @export
#' @family fr
#' @family FR
#' @details Note for female and male components that we fall back on generic
#' versions if the locale
#' doesn't provide a male/female version.
#' e.g., if no female first name we use first
#' name
#' @examples
#' x <- PersonProvider_fr_FR$new()
#' x$locale
#' x$render()
#' x$first_name()
#' x$first_name_female()
#' x$first_name_male()
#' x$last_name()
#' x$last_name_female()
#' x$last_name_male()
PersonProvider_fr_FR <- R6::R6Class(
  "PersonProvider_fr_FR",
  inherit = PersonProvider,
  private = list(
    formats = person_formats_fr_fr,
    persons = person_fr_fr,
    locale_ = "fr_FR"
  )
)
