% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cie-search.R
\name{cie_search}
\alias{cie_search}
\title{Busqueda difusa (fuzzy) de terminos medicos CIE-10}
\usage{
cie_search(
  texto,
  threshold = 0.7,
  max_results = 50,
  campo = c("descripcion", "inclusion"),
  solo_fuzzy = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{texto}{String termino medico en espanol o sigla (ej. "diabetes", "IAM", "TBC")}

\item{threshold}{Numeric entre 0 y 1, umbral similitud Jaro-Winkler (default 0.70)}

\item{max_results}{Integer, maximo resultados a retornar (default 50)}

\item{campo}{Character, campo busqueda ("descripcion" o "inclusion")}

\item{solo_fuzzy}{Logical, usar solo busqueda fuzzy sin busqueda exacta (default FALSE)}

\item{verbose}{Logical, mostrar mensajes informativos (default TRUE). Usar FALSE en scripts.}
}
\value{
tibble ordenado por score descendente (1.0 = coincidencia exacta).
Incluye atributo "sigla_expandida" si se uso una sigla.
}
\description{
Busca en descripciones CIE-10 usando multiples estrategias:
\enumerate{
\item Expansion de siglas medicas (IAM, TBC, DM, etc.)
\item Busqueda exacta por subcadena (mas rapida)
\item Busqueda fuzzy con Jaro-Winkler (tolera typos)
}
}
\details{
La busqueda es tolerante a tildes: "neumonia" encuentra "neumonia".
Soporta siglas medicas comunes: "IAM" busca "infarto agudo miocardio".
}
\examples{
# Busqueda basica
cie_search("diabetes")

\donttest{
cie_search("neumonia")

# Busqueda por siglas medicas
cie_search("IAM")
cie_search("DM2")

# Tolerante a tildes y typos
cie_search("diabetis")

# Buscar en inclusiones
cie_search("bacteriana", campo = "inclusion")
}
}
