\name{alsfrs_r_score}
\alias{alsfrs_r_score}
\title{
Revised Amyotrophic Lateral Sclerosis Functional Rating Scale (ALSFRS-R)
}
\description{
Calculates the ALSFRS-R score, a validated instrument for monitoring the progression of disability in patients with Amyotrophic Lateral Sclerosis (ALS). It evaluates four domains: Bulbar, Fine Motor, Gross Motor, and Respiratory function. Each of the 12 items is scored from 0 (Complete Loss of Function) to 4 (Normal Function), yielding a total score between 0 and 48.
}
\usage{
alsfrs_r_score(speech, salivation, swallowing, handwriting, cutting_food,
               dressing_hygiene, turning_in_bed, walking, climbing_stairs,
               dyspnea, orthopnea, respiratory_insufficiency)
}
\arguments{
  \item{speech}{
Numeric (0-4). Assessment of speech processes.
}
  \item{salivation}{
Numeric (0-4). Assessment of salivation.
}
  \item{swallowing}{
Numeric (0-4). Assessment of swallowing.
}
  \item{handwriting}{
Numeric (0-4). Assessment of handwriting ability.
}
  \item{cutting_food}{
Numeric (0-4). Ability to cut food and handle utensils (with or without gastrostomy).
}
  \item{dressing_hygiene}{
Numeric (0-4). Ability to dress and perform hygiene.
}
  \item{turning_in_bed}{
Numeric (0-4). Ability to turn in bed and adjust bed clothes.
}
  \item{walking}{
Numeric (0-4). Walking ability.
}
  \item{climbing_stairs}{
Numeric (0-4). Ability to climb stairs.
}
  \item{dyspnea}{
Numeric (0-4). Shortness of breath.
}
  \item{orthopnea}{
Numeric (0-4). Shortness of breath while lying flat.
}
  \item{respiratory_insufficiency}{
Numeric (0-4). Use of respiratory appliances (BiPAP, Ventilator).
}
}
\value{
A list containing:
\item{ALSFRS_R_Score}{The calculated total score (Range 0-48).}
\item{Subscores}{Breakdown of scores by functional domain.}
\item{Interpretation}{Context regarding the score directionality.}
}
\references{
Cedarbaum JM, Stambler N, Malta E, et al. The ALSFRS-R: a revised ALS functional rating scale that incorporates assessments of respiratory function. BDNF ALS Study Group (Phase III). J Neurol Sci. 1999;169(1-2):13-21. doi:10.1016/s0022-510x(99)00210-5
}
\examples{

# Example 1: Mild Disease
# All normal except slight speech (3) and handwriting (3)
alsfrs_r_score(3, 4, 4, 3, 4, 4, 4, 4, 4, 4, 4, 4)

# Example 2: Advanced Disease
# Bulbar and Respiratory impairment
alsfrs_r_score(1, 2, 1, 0, 0, 0, 1, 0, 0, 2, 1, 0)
}
