\name{ball_score_cll}
\alias{ball_score_cll}
\title{
BALL Score for Relapsed/Refractory CLL
}
\description{
Calculates the BALL (Beta-2 microglobulin, Anemia, LDH, Last therapy) score to prognosticate Overall Survival in patients with relapsed or refractory Chronic Lymphocytic Leukemia (CLL). This score uses four readily available clinical variables to stratify patients into Low, Intermediate, or High risk categories.
}
\usage{
ball_score_cll(beta2_microglobulin_mg_l, hemoglobin_g_dl, sex, ldh_elevated,
               last_therapy_pfs_lt_24mo)
}
\arguments{
  \item{beta2_microglobulin_mg_l}{
Numeric. Serum Beta-2 microglobulin level in mg/L. (> 3.5 mg/L adds +1 point).
}
  \item{hemoglobin_g_dl}{
Numeric. Hemoglobin level in g/dL. Anemia (Male < 12 g/dL; Female < 11 g/dL) adds +1 point.
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). Used to determine the anemia threshold.
}
  \item{ldh_elevated}{
Numeric (0 or 1). Is Lactate Dehydrogenase (LDH) greater than the Upper Limit of Normal? (1 = Yes, +1 point).
}
  \item{last_therapy_pfs_lt_24mo}{
Numeric (0 or 1). Was the duration of response (progression-free survival) to the last prior therapy < 24 months? (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{BALL_Score}{The calculated score (Range 0-4).}
\item{Risk_Group}{Classification (Low 0-1, Intermediate 2-3, High 4).}
\item{Est_2Yr_Overall_Survival}{Estimated 2-year Overall Survival percentage based on the validation cohort.}
}
\references{
Grosicki S, et al. The BALL score: a new prognostic model for relapsed/refractory chronic lymphocytic leukemia patients. Leuk Lymphoma. 2020.
}
\examples{

# Example 1: High Risk
# B2M 5.0 (+1), Hb 10 (Male, +1), High LDH (+1), Short prior remission (+1)
# Score = 4
ball_score_cll(5.0, 10.0, "male", 1, 1)

# Example 2: Low Risk
# B2M 2.0 (0), Hb 13 (Female, 0), Normal LDH (0), Long prior remission (0)
# Score = 0
ball_score_cll(2.0, 13.0, "female", 0, 0)
}
