\name{bastion_classification_lower_limb}
\alias{bastion_classification_lower_limb}
\title{
Bastion Classification of Lower Limb Blast Injuries
}
\description{
Classifies lower limb injuries caused by blasts (e.g., Improvised Explosive Devices/IEDs) based on the most proximal level of injury. This classification system aids in communicating injury severity, anticipating resource needs (surgical consultations), and guiding hemorrhage control (tourniquet viability).
}
\usage{
bastion_classification_lower_limb(injury_level, segmental_injury = 0,
                                  abdominal_injury = 0, genital_perineal_injury = 0,
                                  pelvic_ring_injury = 0, upper_limb_injury = 0)
}
\arguments{
  \item{injury_level}{
Numeric (1-5). The most proximal extent of the injury.
1: Injury confined to the foot.
2: Injury involving the lower leg (permits effective below-knee tourniquet).
3: Injury involving proximal lower leg or thigh (permits effective above-knee tourniquet).
4: Proximal thigh injury (prevents effective tourniquet application).
5: Any injury with buttock involvement.
}
  \item{segmental_injury}{
Numeric (0 or 1). Presence of potentially viable tissue distal to the most proximal injury (Segmental Injury). (1 = Yes).
}
  \item{abdominal_injury}{
Numeric (0 or 1). Associated intraperitoneal abdominal injury. (1 = Yes).
}
  \item{genital_perineal_injury}{
Numeric (0 or 1). Associated genitalia or perineal injury. (1 = Yes).
}
  \item{pelvic_ring_injury}{
Numeric (0 or 1). Associated pelvic ring injury. (1 = Yes).
}
  \item{upper_limb_injury}{
Numeric (0 or 1). Associated upper limb injury. (1 = Yes).
}
}
\value{
A list containing:
\item{Bastion_Class}{The determined Bastion Class (1-5).}
\item{Description}{Anatomical description of the class.}
\item{Tourniquet_Guide}{Guidance on the feasibility of tourniquet application.}
\item{Associated_Injuries}{List of associated complications present.}
}
\references{
Jacobs N, Rourke K, Keene D, et al. Lower limb injuries caused by improvised explosive devices: proposed 'Bastion classification' and prospective validation. Injury. 2012;43(9):1442-1446. doi:10.1016/j.injury.2012.05.001
}
\examples{

# Example 1: Class 3 Injury
# Proximal lower leg injury (Level 3), with upper limb injury
bastion_classification_lower_limb(3, 0, 0, 0, 0, 1)

# Example 2: Class 5 Injury
# Buttock involvement (Level 5), with abdominal and pelvic injury
bastion_classification_lower_limb(5, 0, 1, 0, 1, 0)
}
