\name{blood_volume_calculation}
\alias{blood_volume_calculation}
\title{
Estimated Blood Volume (Nadler Equation)
}
\description{
Calculates the estimated total blood volume in Liters using the Nadler equation. This method is considered more accurate than simple weight-based estimates (e.g., 70 mL/kg) because it accounts for the patient's height and sex. Accurate blood volume estimation is critical for procedures like plasmapheresis or assessing volume status in shock.
}
\usage{
blood_volume_calculation(sex, height_cm, weight_kg)
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{height_cm}{
Numeric. Patient height in centimeters.
}
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
}
\value{
A list containing:
\item{Estimated_Blood_Volume_L}{The calculated total blood volume in Liters.}
\item{Formula}{The method used (Nadler Equation).}
}
\references{
Nadler SB, Hidalgo JH, Bloch T. Prediction of blood volume in normal human adults. Surgery. 1962;51(2):224-232.
}
\examples{

# Example 1: Male
# 180cm, 80kg
# BV = (0.3669 * 1.8^3) + (0.03219 * 80) + 0.6041 = ~5.3 L
blood_volume_calculation("male", 180, 80)

# Example 2: Female
# 160cm, 60kg
# BV = (0.3561 * 1.6^3) + (0.03308 * 60) + 0.1833 = ~3.6 L
blood_volume_calculation("female", 160, 60)
}
