\name{caroc_fracture_risk}
\alias{caroc_fracture_risk}
\title{
CAROC System for Fracture Risk Assessment
}
\description{
Calculates the 10-year risk of major osteoporotic fracture using the 2010 Canadian Association of Radiologists and Osteoporosis Canada (CAROC) system. This tool stratifies patients into Low, Moderate, or High risk categories based on Age, Sex, Femoral Neck T-score, Prior Fragility Fracture, and Glucocorticoid use.
}
\usage{
caroc_fracture_risk(sex, age, femoral_neck_t_score,
                    prior_fragility_fracture, glucocorticoid_use)
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{age}{
Numeric. Patient age in years (Valid for age >= 50).
}
  \item{femoral_neck_t_score}{
Numeric. Bone Mineral Density (BMD) T-score at the femoral neck.
}
  \item{prior_fragility_fracture}{
Numeric (0 or 1). History of fragility fracture after age 40. (1 = Yes).
Note: Presence increases risk by one category.
}
  \item{glucocorticoid_use}{
Numeric (0 or 1). Recent prolonged use of systemic glucocorticoids (e.g., >3 months). (1 = Yes).
Note: Presence increases risk by one category.
}
}
\value{
A list containing:
\item{Risk_Category}{The calculated risk zone (Low, Moderate, High).}
\item{Ten_Year_Fracture_Risk}{The estimated percentage risk of major osteoporotic fracture over 10 years.}
}
\references{
Papaioannou A, Morin S, Cheung AM, et al. 2010 clinical practice guidelines for the diagnosis and management of osteoporosis in Canada: summary. CMAJ. 2010;182(17):1864-1873. doi:10.1503/cmaj.100771
}
\examples{

# Example 1: Moderate Risk bumped to High
# 65yo Female, T-score -2.0 (Moderate Base), Prior Fracture (+1 Category)
caroc_fracture_risk("female", 65, -2.0, 1, 0)

# Example 2: Low Risk
# 55yo Male, T-score -1.0, No risk factors
caroc_fracture_risk("male", 55, -1.0, 0, 0)
}
