\name{choles_score_duration}
\alias{choles_score_duration}
\title{
CholeS Score for Laparoscopic Cholecystectomy Duration
}
\description{
Calculates the CholeS Score to predict the duration and difficulty of elective laparoscopic cholecystectomy. This score, derived from the CholeS Study, helps in operating list planning and identifying cases that may require senior surgical expertise due to predicted complexity.
}
\usage{
choles_score_duration(sex, age, history_acute_cholecystitis, bmi, asa_class_ge_3)
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Male adds +1 point).
}
  \item{age}{
Numeric. Patient age in years.
< 60: 0 pts.
60-70: 1 pt.
> 70: 2 pts.
}
  \item{history_acute_cholecystitis}{
Numeric (0 or 1). History of acute cholecystitis. (1 = Yes, +1 point).
}
  \item{bmi}{
Numeric. Body Mass Index (kg/m^2).
< 30: 0 pts.
30-35: 1 pt.
> 35: 2 pts.
}
  \item{asa_class_ge_3}{
Numeric (0 or 1). ASA Physical Status III, IV, or V. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{CholeS_Score}{The calculated score (Range 0-7).}
\item{Risk_Category}{Risk stratification (Low, Medium, High).}
\item{Est_Duration}{Estimated mean duration of surgery.}
}
\references{
CholeS Study Group, West Midlands Research Collaborative. Population-based cohort study of variation in the use of emergency cholecystectomy for benign gallbladder diseases. Br J Surg. 2016;103(12):1716-1726.
}
\examples{

# Example 1: High Difficulty
# Male (+1), 75yo (+2), Hx Acute Chole (+1), BMI 36 (+2), ASA III (+1)
# Score = 7
choles_score_duration("male", 75, 1, 36, 1)

# Example 2: Low Difficulty
# Female (0), 45yo (0), No Hx (0), BMI 28 (0), ASA I (0)
# Score = 0
choles_score_duration("female", 45, 0, 28, 0)
}
