\name{ciwa_ar_alcohol_withdrawal}
\alias{ciwa_ar_alcohol_withdrawal}
\title{
Clinical Institute Withdrawal Assessment for Alcohol, Revised (CIWA-Ar)
}
\description{
Calculates the CIWA-Ar score, the gold-standard tool for assessing the severity of alcohol withdrawal syndrome. The scale consists of 10 items: 9 items scored 0-7 and 1 item (Orientation) scored 0-4. The total score guides the administration of benzodiazepines in symptom-triggered protocols.
}
\usage{
ciwa_ar_alcohol_withdrawal(nausea_vomiting, tremor, paroxysmal_sweats, anxiety,
                           agitation, tactile_disturbances, auditory_disturbances,
                           visual_disturbances, headache, orientation)
}
\arguments{
  \item{nausea_vomiting}{
Numeric (0-7). 0=None, 4=Intermittent nausea/dry heaves, 7=Constant nausea/vomiting.
}
  \item{tremor}{
Numeric (0-7). 0=No tremor, 7=Severe, visible with arms not extended.
}
  \item{paroxysmal_sweats}{
Numeric (0-7). 0=No sweat visible, 7=Drenching sweats.
}
  \item{anxiety}{
Numeric (0-7). 0=No anxiety, 7=Acute panic states.
}
  \item{agitation}{
Numeric (0-7). 0=Normal activity, 7=Pacing constantly/thrashing.
}
  \item{tactile_disturbances}{
Numeric (0-7). 0=None, 7=Continuous hallucinations.
}
  \item{auditory_disturbances}{
Numeric (0-7). 0=None, 7=Continuous hallucinations.
}
  \item{visual_disturbances}{
Numeric (0-7). 0=None, 7=Continuous hallucinations.
}
  \item{headache}{
Numeric (0-7). 0=None, 7=Very severe.
}
  \item{orientation}{
Numeric (0-4). 0=Oriented, 4=Disoriented to place and person.
}
}
\value{
A list containing:
\item{CIWA_Ar_Score}{The calculated total score (Range 0-67).}
\item{Severity_Category}{Classification (Mild <8, Moderate 8-15, Severe >15).}
\item{Management_Guideline}{General treatment recommendation based on severity.}
}
\references{
Sullivan JT, Sykora K, Schneiderman J, Naranjo CA, Sellers EM. Assessment of alcohol withdrawal: the revised clinical institute withdrawal assessment for alcohol scale (CIWA-Ar). Br J Addict. 1989;84(11):1353-1357. doi:10.1111/j.1360-0443.1989.tb00737.x
}
\examples{

# Example 1: Severe Withdrawal
# Tremor 7, Sweats 7, Agitation 5, Hallucinations 3
# Score = 22
ciwa_ar_alcohol_withdrawal(0, 7, 7, 0, 5, 0, 0, 3, 0, 0)

# Example 2: Mild Withdrawal
# Tremor 2, Anxiety 2
# Score = 4
ciwa_ar_alcohol_withdrawal(0, 2, 0, 2, 0, 0, 0, 0, 0, 0)
}
