\name{ctcae_v5_grading}
\alias{ctcae_v5_grading}
\title{
Common Terminology Criteria for Adverse Events (CTCAE) v5.0
}
\description{
Provides definitions for the general grading scale (1-5) of the CTCAE v5.0 and calculates specific grades for common hematologic toxicities (Neutropenia and Thrombocytopenia) based on laboratory values. The CTCAE is the standard system for reporting the severity of adverse events in cancer therapy.
}
\usage{
ctcae_v5_grading(grade_index = NULL, anc_count = NULL, platelet_count = NULL)
}
\arguments{
  \item{grade_index}{
Numeric (1-5) (Optional). If provided, returns the general definition for that specific severity grade.
}
  \item{anc_count}{
Numeric (Optional). Absolute Neutrophil Count in cells/mm3. If provided, calculates the specific CTCAE grade for Neutropenia.
}
  \item{platelet_count}{
Numeric (Optional). Platelet count in cells/mm3. If provided, calculates the specific CTCAE grade for Thrombocytopenia.
}
}
\value{
A list containing:
\item{Grade}{The grade queried or calculated.}
\item{General_Definition}{The general description of severity (if grade_index is used).}
\item{Toxicity}{The specific toxicity evaluated (if lab values used).}
\item{Calculated_Grade}{The determined grade based on v5.0 thresholds.}
}
\references{
Common Terminology Criteria for Adverse Events (CTCAE) Version 5.0. US Department of Health and Human Services, National Institutes of Health, National Cancer Institute. Published November 27, 2017.
}
\examples{

# Example 1: Get definition for Grade 3
ctcae_v5_grading(grade_index = 3)

# Example 2: Calculate Grade for Neutropenia
# ANC 800 (Grade 3: 500 - <1000)
ctcae_v5_grading(anc_count = 800)

# Example 3: Calculate Grade for Thrombocytopenia
# Platelets 30,000 (Grade 3: 25,000 - <50,000)
ctcae_v5_grading(platelet_count = 30000)
}
