\name{euroscore_ii}
\alias{euroscore_ii}
\title{
European System for Cardiac Operative Risk Evaluation (EuroSCORE) II
}
\description{
Calculates the EuroSCORE II, which predicts in-hospital mortality after major cardiac surgery. This model improves upon the original EuroSCORE by incorporating a contemporary patient population and using a full logistic regression model, allowing for a more accurate and nuanced risk prediction.
}
\usage{
euroscore_ii(age, gender, renal_impairment, extracardiac_arteriopathy, poor_mobility,
             previous_cardiac_surgery, chronic_lung_disease, active_endocarditis,
             critical_preoperative_state, diabetes_on_insulin, nyha_class,
             ccs_class_4_angina, lv_function, recent_mi, pulmonary_hypertension,
             urgency, weight_of_intervention, surgery_on_thoracic_aorta)
}
\arguments{
  \item{age}{Numeric. Patient age in years.}
  \item{gender}{Character. "male" or "female".}
  \item{renal_impairment}{Character. Degree of renal impairment, categorized by Creatinine Clearance (CrCl) or Dialysis status. Options: "normal" (CrCl > 85 mL/min), "creatinine_clearance_50_85" (50-85 mL/min), "creatinine_clearance_lt_50" (< 50 mL/min), or "dialysis".}
  \item{extracardiac_arteriopathy}{Numeric (0 or 1). Includes claudication, carotid occlusion >50\%, or previous/planned intervention on peripheral arteries or aorta.}
  \item{poor_mobility}{Numeric (0 or 1). Severe impairment of mobility due to musculoskeletal or neurological dysfunction.}
  \item{previous_cardiac_surgery}{Numeric (0 or 1). History of previous major cardiac operation involving opening of the pericardium.}
  \item{chronic_lung_disease}{Numeric (0 or 1). Long-term use of bronchodilators or steroids for lung disease.}
  \item{active_endocarditis}{Numeric (0 or 1). Patient is still on antibiotic treatment for endocarditis at the time of surgery.}
  \item{critical_preoperative_state}{Numeric (0 or 1). Presence of critical signs (e.g., VT/VF, cardiac massage, pre-op ventilation, inotropes, IABP/VAD before OR, acute renal failure/anuria).}
  \item{diabetes_on_insulin}{Numeric (0 or 1). Diabetes mellitus treated with insulin.}
  \item{nyha_class}{Numeric (1, 2, 3, or 4). New York Heart Association functional class.}
  \item{ccs_class_4_angina}{Numeric (0 or 1). Angina at rest (Canadian Cardiovascular Society Class 4 Angina).}
  \item{lv_function}{Character. Left Ventricular Ejection Fraction (LVEF). Options: "good" (> 50\%), "moderate" (31-50\%), "poor" (21-30\%), or "very_poor" (<= 20\%).}
  \item{recent_mi}{Numeric (0 or 1). Myocardial infarction within the last 90 days.}
  \item{pulmonary_hypertension}{Character. Systolic Pulmonary Artery Pressure (PAP). Options: "none" (< 31 mmHg), "moderate" (31-55 mmHg), or "severe" (> 55 mmHg).}
  \item{urgency}{Character. Urgency of the procedure. Options: "elective", "urgent", "emergency", or "salvage" (most critical).}
  \item{weight_of_intervention}{Character. The type of procedure. Options: "isolated_cabg", "single_non_cabg", "two_procedures" (e.g., CABG + valve), or "three_procedures".}
  \item{surgery_on_thoracic_aorta}{Numeric (0 or 1). Surgery on the thoracic aorta (including root and arch).}
}
\details{
The EuroSCORE II is calculated using a logistic regression model:
\deqn{Predicted Mortality = \frac{e^L}{1 + e^L}}
Where \eqn{L} is the linear predictor (\eqn{\beta_0 + \sum \beta_i X_i}) derived from the 18 patient-related risk factors and surgical factors.
}
\value{
  A list containing the predicted in-hospital mortality risk as a percentage.
}
\references{
Nashef SAM, Roques F, Sharples PE, et al. EuroSCORE II. Eur J Cardiothorac Surg. 2012;41(4):734-744. doi:10.1093/ejcts/ezs043
}
\examples{
euroscore_ii(
  age = 65,
  gender = "male",
  renal_impairment = "normal",
  extracardiac_arteriopathy = 0,
  poor_mobility = 0,
  previous_cardiac_surgery = 0,
  chronic_lung_disease = 0,
  active_endocarditis = 0,
  critical_preoperative_state = 0,
  diabetes_on_insulin = 0,
  nyha_class = 1,
  ccs_class_4_angina = 0,
  lv_function = "good",
  recent_mi = 0,
  pulmonary_hypertension = "none",
  urgency = "elective",
  weight_of_intervention = "isolated_cabg",
  surgery_on_thoracic_aorta = 0
)
}
