\name{feverpain_score}
\alias{feverpain_score}
\title{
FeverPAIN Score for Strep Pharyngitis
}
\description{
Calculates the FeverPAIN score to estimate the probability of streptococcal pharyngitis and guide antibiotic prescribing. It evaluates five clinical criteria: Fever, Purulence, Attend rapidly (<= 3 days), Inflamed tonsils, and No cough/coryza.
}
\usage{
feverpain_score(fever_24hr, purulence, attend_rapidly_3days,
                inflamed_tonsils, no_cough)
}
\arguments{
  \item{fever_24hr}{
Numeric (0 or 1). Fever in the last 24 hours. (1 = Yes, +1 point).
}
  \item{purulence}{
Numeric (0 or 1). Purulence (pus) on tonsils. (1 = Yes, +1 point).
}
  \item{attend_rapidly_3days}{
Numeric (0 or 1). Patient attended within 3 days or less of symptom onset. (1 = Yes, +1 point).
}
  \item{inflamed_tonsils}{
Numeric (0 or 1). Severely inflamed tonsils. (1 = Yes, +1 point).
}
  \item{no_cough}{
Numeric (0 or 1). Absence of cough or coryza. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{FeverPAIN_Score}{The calculated score (Range 0-5).}
\item{Strep_Probability}{Estimated percentage risk of streptococcal infection.}
\item{Recommendation}{Clinical guidance regarding antibiotic use (None, Delayed, or Immediate).}
}
\references{
Little P, Moore M, Hobbs FD, et al. PRImary care Streptococcal Management (PRISM) study: identifying clinical variables associated with Lancefield group A beta-haemolytic streptococci and Lancefield group C/G streptococci from patients presenting with acute sore throat. BMJ Open. 2013;3(10):e003943. doi:10.1136/bmjopen-2013-003943
}
\examples{

# Example 1: High Risk
# Fever (+1), Pus (+1), Rapid onset (+1), Inflamed (+1), No Cough (+1)
# Score = 5
feverpain_score(1, 1, 1, 1, 1)

# Example 2: Moderate Risk
# No Fever (0), Pus (0), Rapid onset (+1), Inflamed (+1), No Cough (+1)
# Score = 3
feverpain_score(0, 0, 1, 1, 1)
}
