\name{fleischner_nodule_guidelines}
\alias{fleischner_nodule_guidelines}
\title{
Fleischner Society Guidelines for Incidental Pulmonary Nodules (2017)
}
\description{
Provides follow-up recommendations for incidental pulmonary nodules detected on CT scans in patients >= 35 years old. The guidelines differentiate management based on nodule consistency (Solid, Pure Ground-Glass, Part-Solid), multiplicity, size, and patient risk factors (smoking history, exposure).
}
\usage{
fleischner_nodule_guidelines(nodule_type, multiplicity, size_mm,
                             risk_level = "low")
}
\arguments{
  \item{nodule_type}{
String. Consistency of the nodule. Options: "solid", "ground_glass", or "part_solid".
}
  \item{multiplicity}{
String. Number of nodules. Options: "single" or "multiple".
}
  \item{size_mm}{
Numeric. Size of the nodule (average diameter) in millimeters. For multiple nodules, use the size of the largest/most suspicious nodule.
}
  \item{risk_level}{
String. Patient risk status. Options: "low" (minimal/no history of smoking or other known risk factors) or "high" (history of smoking or other known risk factors). Defaults to "low".
}
}
\value{
A list containing:
\item{Guideline_Recommendation}{The specific follow-up action plan (e.g., intervals for CT surveillance).}
}
\references{
MacMahon H, Naidich DP, Goo JM, et al. Guidelines for Management of Incidental Pulmonary Nodules Detected on CT Images: From the Fleischner Society 2017. Radiology. 2017;284(1):228-243. doi:10.1148/radiol.2017161659
}
\examples{

# Example 1: Low Risk, Single Solid Nodule < 6mm
# Result: No follow-up
fleischner_nodule_guidelines("solid", "single", 4, "low")

# Example 2: Single Part-Solid Nodule >= 6mm
# Result: CT at 3-6 months
fleischner_nodule_guidelines("part_solid", "single", 8, "low")

# Example 3: High Risk, Single Solid Nodule 7mm
# Result: CT 6-12 mo, then 18-24 mo
fleischner_nodule_guidelines("solid", "single", 7, "high")
}
