\name{gigpa_score}
\alias{gigpa_score}
\title{
GI-GPA (Graded Prognostic Assessment for Gastrointestinal Cancers)
}
\description{
Calculates the GI-GPA score, a prognostic index for patients with brain metastases from gastrointestinal cancers. The score uses four factors: Karnofsky Performance Status (KPS), age, presence of extracranial metastases, and number of brain metastases to predict median survival.
}
\usage{
gigpa_score(kps, age, extracranial_metastases, num_brain_metastases)
}
\arguments{
  \item{kps}{
Numeric. Karnofsky Performance Status score (0-100).
>=90: 2.0 pts.
80: 1.5 pts.
70: 1.0 pt.
<70: 0 pts.
}
  \item{age}{
Numeric. Patient age in years.
<70: 0.5 pts.
>=70: 0 pts.
}
  \item{extracranial_metastases}{
Numeric (0 or 1). Presence of extracranial metastases. (1 = Present: 0 pts, 0 = Absent: 1.0 pt).
}
  \item{num_brain_metastases}{
Numeric. Number of brain metastases.
1: 0.5 pts.
>1: 0 pts.
}
}
\value{
A list containing:
\item{GI_GPA_Score}{The calculated prognostic score (Range 0.0 - 4.0).}
\item{Median_Survival}{Estimated median survival time in months.}
}
\references{
Sperduto PW, Kased N, Roberge D, et al. Summary report on the graded prognostic assessment: an accurate and facile diagnosis-specific tool to estimate survival for patients with brain metastases. J Clin Oncol. 2012;30(4):419-425. doi:10.1200/JCO.2011.38.0527
}
\examples{

# Example 1: Good Prognosis
# KPS 90 (+2.0), Age 60 (+0.5), No extra mets (+1.0), 1 brain met (+0.5)
# Score = 4.0
gigpa_score(90, 60, 0, 1)

# Example 2: Poor Prognosis
# KPS 60 (0), Age 75 (0), Extra mets (+0), >1 brain met (0)
# Score = 0.0
gigpa_score(60, 75, 1, 3)
}
